/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.binarydto.fieldcodec.primitive;

import io.datarouter.bytes.LengthAndValue;
import io.datarouter.bytes.binarydto.fieldcodec.BinaryDtoBaseFieldCodec;
import io.datarouter.bytes.codec.floatcodec.ComparableFloatCodec;

public class FloatBinaryDtoFieldCodec
extends BinaryDtoBaseFieldCodec<Float> {
    private static final ComparableFloatCodec CODEC = ComparableFloatCodec.INSTANCE;

    @Override
    public boolean isFixedLength() {
        return true;
    }

    @Override
    public int fixedLength() {
        return CODEC.length();
    }

    @Override
    public byte[] encode(Float value) {
        return CODEC.encode(value.floatValue());
    }

    @Override
    public Float decode(byte[] bytes, int offset) {
        return Float.valueOf(CODEC.decode(bytes, offset));
    }

    @Override
    public LengthAndValue<Float> decodeWithLength(byte[] bytes, int offset) {
        int length = this.fixedLength();
        float value = this.decode(bytes, offset).floatValue();
        return new LengthAndValue<Float>(length, Float.valueOf(value));
    }

    @Override
    public int compareAsIfEncoded(Float left, Float right) {
        return Float.compare(left.floatValue(), right.floatValue());
    }
}

