/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.binarydto.fieldcodec.primitive;

import io.datarouter.bytes.LengthAndValue;
import io.datarouter.bytes.binarydto.fieldcodec.BinaryDtoBaseFieldCodec;
import io.datarouter.bytes.codec.charcodec.ComparableCharCodec;

public class CharBinaryDtoFieldCodec
extends BinaryDtoBaseFieldCodec<Character> {
    private static final ComparableCharCodec CODEC = ComparableCharCodec.INSTANCE;

    @Override
    public boolean isFixedLength() {
        return true;
    }

    @Override
    public int fixedLength() {
        return CODEC.length();
    }

    @Override
    public byte[] encode(Character value) {
        return CODEC.encode(value.charValue());
    }

    @Override
    public Character decode(byte[] bytes, int offset) {
        return Character.valueOf(CODEC.decode(bytes, offset));
    }

    @Override
    public LengthAndValue<Character> decodeWithLength(byte[] bytes, int offset) {
        int length = this.fixedLength();
        char value = this.decode(bytes, offset).charValue();
        return new LengthAndValue<Character>(length, Character.valueOf(value));
    }

    @Override
    public int compareAsIfEncoded(Character left, Character right) {
        return Character.compare(left.charValue(), right.charValue());
    }
}

