/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.binarydto.fieldcodec.other;

import io.datarouter.bytes.ByteTool;
import io.datarouter.bytes.LengthAndValue;
import io.datarouter.bytes.VarIntTool;
import io.datarouter.bytes.binarydto.fieldcodec.BinaryDtoBaseFieldCodec;
import io.datarouter.bytes.binarydto.internal.BinaryDtoNullFieldTool;
import java.lang.reflect.Array;
import java.util.ArrayList;

public class ObjectArrayBinaryDtoFieldCodec<T>
extends BinaryDtoBaseFieldCodec<T[]> {
    private final Class<T> itemClass;
    private final BinaryDtoBaseFieldCodec<T> itemCodec;
    private final boolean isNullableItems;

    public ObjectArrayBinaryDtoFieldCodec(Class<T> itemClass, BinaryDtoBaseFieldCodec<T> itemCodec, boolean isNullableItems) {
        this.itemClass = itemClass;
        this.itemCodec = itemCodec;
        this.isNullableItems = isNullableItems;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[] encode(T[] value) {
        int size = value.length;
        ArrayList<byte[]> byteArrays = new ArrayList<byte[]>(2 * size + 1);
        byte[] sizeBytes = VarIntTool.encode(size);
        byteArrays.add(sizeBytes);
        T[] TArray = value;
        int n = value.length;
        int n2 = 0;
        while (n2 < n) {
            T item = TArray[n2];
            if (item == null) {
                if (!this.isNullableItems) throw new IllegalArgumentException("Cannot contain nulls");
                byteArrays.add(BinaryDtoNullFieldTool.NULL_INDICATOR_TRUE_ARRAY);
            } else {
                if (this.isNullableItems) {
                    byteArrays.add(BinaryDtoNullFieldTool.NULL_INDICATOR_FALSE_ARRAY);
                }
                byte[] itemBytes = this.itemCodec.encode(item);
                byteArrays.add(itemBytes);
            }
            ++n2;
        }
        return ByteTool.concat(byteArrays);
    }

    @Override
    public T[] decode(byte[] bytes, int offset) {
        return (Object[])this.decodeWithLength((byte[])bytes, (int)offset).value;
    }

    @Override
    public LengthAndValue<T[]> decodeWithLength(byte[] bytes, int offset) {
        int cursor = offset;
        int size = VarIntTool.decodeInt(bytes, cursor);
        cursor += VarIntTool.length(size);
        Object[] value = (Object[])Array.newInstance(this.itemClass, size);
        int i = 0;
        while (i < size) {
            boolean isItemNull = false;
            if (this.isNullableItems) {
                isItemNull = BinaryDtoNullFieldTool.decodeNullIndicator(bytes[cursor]);
                ++cursor;
            }
            if (isItemNull) {
                Array.set(value, i, null);
            } else {
                LengthAndValue<T> lengthAndValue = this.itemCodec.decodeWithLength(bytes, cursor);
                cursor += lengthAndValue.length;
                Array.set(value, i, lengthAndValue.value);
            }
            ++i;
        }
        int length = cursor - offset;
        return new LengthAndValue<T[]>(length, value);
    }
}

