/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.binarydto.fieldcodec.other;

import io.datarouter.bytes.LengthAndValue;
import io.datarouter.bytes.binarydto.fieldcodec.BinaryDtoBaseFieldCodec;
import io.datarouter.bytes.codec.stringcodec.TerminatedStringCodec;

public class EnumBinaryDtoFieldCodec<E extends Enum<E>>
extends BinaryDtoBaseFieldCodec<E> {
    private static final TerminatedStringCodec CODEC = TerminatedStringCodec.US_ASCII;
    private final Class<E> type;

    public EnumBinaryDtoFieldCodec(Class<E> type) {
        this.type = type;
    }

    @Override
    public byte[] encode(E value) {
        return CODEC.encode(((Enum)value).name());
    }

    @Override
    public E decode(byte[] bytes, int offset) {
        return (E)((Enum)this.decodeWithLength((byte[])bytes, (int)offset).value);
    }

    @Override
    public LengthAndValue<E> decodeWithLength(byte[] bytes, int offset) {
        LengthAndValue<String> stringLengthAndValue = CODEC.decode(bytes, offset);
        int length = stringLengthAndValue.length;
        E value = Enum.valueOf(this.type, (String)stringLengthAndValue.value);
        return new LengthAndValue<E>(length, value);
    }

    @Override
    public int compareAsIfEncoded(E left, E right) {
        return ((Enum)left).name().compareTo(((Enum)right).name());
    }
}

