/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.binarydto.codec;

import io.datarouter.bytes.ByteTool;
import io.datarouter.bytes.LengthAndValue;
import io.datarouter.bytes.binarydto.dto.BinaryDto;
import io.datarouter.bytes.binarydto.internal.BinaryDtoAllocator;
import io.datarouter.bytes.binarydto.internal.BinaryDtoFieldSchema;
import io.datarouter.bytes.binarydto.internal.BinaryDtoMetadataParser;
import io.datarouter.bytes.binarydto.internal.BinaryDtoNullFieldTool;
import io.datarouter.scanner.Scanner;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BinaryDtoCodec<T extends BinaryDto<T>> {
    private static final Map<Class<? extends BinaryDto<?>>, BinaryDtoCodec<?>> CACHE = new ConcurrentHashMap();
    private static final int MAX_TOKENS_PER_FIELD = 2;
    public final Class<T> dtoClass;
    public final List<Field> fields;
    public final List<? extends BinaryDtoFieldSchema<?>> fieldSchemas;

    private BinaryDtoCodec(Class<T> dtoClass) {
        this.dtoClass = dtoClass;
        T dto = BinaryDtoAllocator.allocate(dtoClass);
        BinaryDtoMetadataParser<T> metadataParser = new BinaryDtoMetadataParser<T>(dto);
        this.fields = metadataParser.listFields();
        this.fieldSchemas = Scanner.of(this.fields).map(field -> {
            if (field == null) {
                return null;
            }
            field.setAccessible(true);
            BinaryDtoFieldSchema fieldSchema = new BinaryDtoFieldSchema((Field)field);
            return fieldSchema;
        }).list();
    }

    public static <T extends BinaryDto<T>> BinaryDtoCodec<T> of(Class<? extends T> dtoClass) {
        BinaryDtoCodec<Object> codec = CACHE.get(dtoClass);
        if (codec == null) {
            codec = new BinaryDtoCodec<T>(dtoClass);
            CACHE.put(dtoClass, codec);
        }
        return codec;
    }

    public List<Field> getFieldsOrdered() {
        return this.fields;
    }

    public byte[] encode(T dto) {
        return this.encodePrefix(dto, this.fieldSchemas.size());
    }

    public byte[] encodePrefix(T dto, int numFields) {
        ArrayList<byte[]> tokens = new ArrayList<byte[]>(2 * this.fieldSchemas.size());
        int i = 0;
        while (i < numFields) {
            BinaryDtoFieldSchema<?> fieldSchema = this.fieldSchemas.get(i);
            if (fieldSchema != null) {
                if (fieldSchema.isNullable()) {
                    if (fieldSchema.isNull(dto)) {
                        tokens.add(BinaryDtoNullFieldTool.NULL_INDICATOR_TRUE_ARRAY);
                    } else {
                        tokens.add(BinaryDtoNullFieldTool.NULL_INDICATOR_FALSE_ARRAY);
                        tokens.add(fieldSchema.encodeValue(dto));
                    }
                } else {
                    if (fieldSchema.isNull(dto)) {
                        String message = String.format("field=%s of class=%s can't contain nulls", fieldSchema.getName(), dto.getClass().getCanonicalName());
                        throw new IllegalArgumentException(message);
                    }
                    tokens.add(fieldSchema.encodeValue(dto));
                }
            }
            ++i;
        }
        return ByteTool.concat(tokens);
    }

    public T decode(byte[] bytes) {
        return (T)((BinaryDto)this.decodeWithLength((byte[])bytes, (int)0).value);
    }

    public LengthAndValue<T> decodeWithLength(byte[] bytes, int offset) {
        T dto = BinaryDtoAllocator.allocate(this.dtoClass);
        int cursor = offset;
        for (BinaryDtoFieldSchema<?> fieldSchema : this.fieldSchemas) {
            cursor += fieldSchema.decodeField(dto, bytes, cursor);
        }
        int length = cursor - offset;
        return new LengthAndValue<T>(length, dto);
    }

    public int decodePrefixLength(byte[] bytes, int offset, int numFields) {
        int cursor = offset;
        int numFieldsDecoded = 0;
        for (BinaryDtoFieldSchema<?> field : this.fieldSchemas) {
            cursor += field.decodeFieldLength(bytes, cursor);
            if (++numFieldsDecoded == numFields) break;
        }
        return cursor - offset;
    }

    public T decodePrefix(byte[] bytes, int offset, int numFields) {
        T dto = BinaryDtoAllocator.allocate(this.dtoClass);
        int cursor = offset;
        int numFieldsDecoded = 0;
        for (BinaryDtoFieldSchema<?> field : this.fieldSchemas) {
            cursor += field.decodeField(dto, bytes, cursor);
            if (++numFieldsDecoded == numFields) break;
        }
        return dto;
    }
}

