/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;

public class PagedObjectArray<E>
implements List<E> {
    private static final int INITIAL_NUM_PAGES = 4;
    private final int pageSize;
    private final int pageBits;
    private final int pageShift;
    private Object[][] pages;
    private int numItems;

    public PagedObjectArray() {
        this(32);
    }

    public PagedObjectArray(int requestedPageSize) {
        this.pageSize = Integer.highestOneBit(requestedPageSize);
        this.pageBits = this.pageSize - 1;
        this.pageShift = Integer.bitCount(this.pageBits);
        this.pages = new Object[4][];
        this.numItems = 0;
    }

    public E[] toArrayOf(Class<E> clazz) {
        Object[] array = (Object[])Array.newInstance(clazz, this.numItems);
        return this.toArray(array);
    }

    private void expandPagesArray() {
        int newPageArrayLength = this.pages.length == 0 ? 1 : this.pages.length * 2;
        Object[][] newPages = new Object[newPageArrayLength][];
        System.arraycopy(this.pages, 0, newPages, 0, this.pages.length);
        this.pages = newPages;
    }

    @Override
    public boolean add(E value) {
        int pageIndex = this.numItems >>> this.pageShift;
        int indexInPage = this.numItems & this.pageBits;
        if (indexInPage == 0) {
            if (pageIndex == this.pages.length) {
                this.expandPagesArray();
            }
            this.pages[pageIndex] = new Object[this.pageSize];
        }
        this.pages[pageIndex][indexInPage] = value;
        ++this.numItems;
        return true;
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> objs) {
        objs.forEach(this::add);
        return objs.size() > 0;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object theirs) {
        return this.stream().anyMatch(ours -> Objects.equals(ours, theirs));
    }

    @Override
    public boolean containsAll(Collection<?> theirs) {
        return theirs.stream().allMatch(this::contains);
    }

    @Override
    public E get(int index) {
        int pageIndex = index >>> this.pageShift;
        int indexInPage = index & this.pageBits;
        return (E)this.pages[pageIndex][indexInPage];
    }

    @Override
    public int indexOf(Object obj) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.numItems == 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new PagedObjectArrayIterator();
    }

    @Override
    public int lastIndexOf(Object obj) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<E> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object obj) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> objs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> objs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.numItems;
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.numItems]);
    }

    @Override
    public <T> T[] toArray(T[] array) {
        T[] output = array.length == this.numItems ? array : (Object[])Array.newInstance(array.getClass().getComponentType(), this.numItems);
        int count = 0;
        int remaining = this.numItems;
        int nextPage = 0;
        while (remaining > 0) {
            int thisPageSize = Math.min(this.pageSize, remaining);
            System.arraycopy(this.pages[nextPage], 0, output, count, thisPageSize);
            count += thisPageSize;
            remaining -= thisPageSize;
            ++nextPage;
        }
        return output;
    }

    private class PagedObjectArrayIterator
    implements Iterator<E> {
        int index = 0;

        PagedObjectArrayIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < PagedObjectArray.this.numItems;
        }

        @Override
        public E next() {
            return PagedObjectArray.this.get(this.index++);
        }
    }
}

