/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes;

import io.datarouter.bytes.ByteUnitType;

public class ByteUnitTool {
    public static final long KiB = ByteUnitType.KiB.getNumBytes();
    public static final long MiB = ByteUnitType.MiB.getNumBytes();

    public static String byteCountToDisplaySize(long sizeInBytes) {
        return ByteUnitTool.byteCountToDisplaySize(sizeInBytes, ByteUnitType.ByteUnitSystem.BINARY);
    }

    public static String byteCountToDisplaySize(long sizeInBytes, ByteUnitType.ByteUnitSystem byteUnitSystem) {
        if (sizeInBytes < 0L) {
            return null;
        }
        if (byteUnitSystem == null) {
            return ByteUnitType.BYTE.getNumBytesDisplay(sizeInBytes);
        }
        Long step = byteUnitSystem.getStep();
        ByteUnitType[] byteUnitTypeArray = ByteUnitType.getAscValues(byteUnitSystem);
        int n = byteUnitTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ByteUnitType unit = byteUnitTypeArray[n2];
            if (step.compareTo(Math.abs(sizeInBytes / unit.getNumBytes())) > 0) {
                return unit.getNumBytesDisplay(sizeInBytes);
            }
            ++n2;
        }
        if (ByteUnitType.ByteUnitSystem.BINARY == byteUnitSystem) {
            return ByteUnitType.PiB.getNumBytesDisplay(sizeInBytes);
        }
        return ByteUnitType.PB.getNumBytesDisplay(sizeInBytes);
    }
}

