/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.codec.array.doublearray;

import io.datarouter.bytes.EmptyArray;
import io.datarouter.bytes.codec.doublecodec.ComparableDoubleCodec;

public class ComparableDoubleArrayCodec {
    public static final ComparableDoubleArrayCodec INSTANCE = new ComparableDoubleArrayCodec();
    private static final ComparableDoubleCodec COMPARABLE_DOUBLE_CODEC = ComparableDoubleCodec.INSTANCE;
    private static final int ITEM_LENGTH = COMPARABLE_DOUBLE_CODEC.length();

    public int itemLength() {
        return ITEM_LENGTH;
    }

    public byte[] encode(double[] values) {
        if (values.length == 0) {
            return EmptyArray.BYTE;
        }
        byte[] bytes = new byte[ITEM_LENGTH * values.length];
        this.encode(values, bytes, 0);
        return bytes;
    }

    public int encode(double[] values, byte[] bytes, int offset) {
        int cursor = offset;
        int i = 0;
        while (i < values.length) {
            COMPARABLE_DOUBLE_CODEC.encode(values[i], bytes, cursor);
            cursor += ITEM_LENGTH;
            ++i;
        }
        return values.length * ITEM_LENGTH;
    }

    public double[] decode(byte[] bytes) {
        return this.decode(bytes, 0, bytes.length);
    }

    public double[] decode(byte[] bytes, int offset, int bytesLength) {
        if (bytesLength == 0) {
            return EmptyArray.DOUBLE;
        }
        if (bytesLength % ITEM_LENGTH != 0) {
            throw new IllegalArgumentException("bytesLength must be multiple of " + ITEM_LENGTH);
        }
        int resultLength = bytesLength / ITEM_LENGTH;
        double[] result = new double[resultLength];
        int cursor = offset;
        int i = 0;
        while (i < resultLength) {
            result[i] = COMPARABLE_DOUBLE_CODEC.decode(bytes, cursor);
            cursor += ITEM_LENGTH;
            ++i;
        }
        return result;
    }
}

