/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.binarydto.fieldcodec.array;

import io.datarouter.bytes.ByteTool;
import io.datarouter.bytes.LengthAndValue;
import io.datarouter.bytes.VarIntTool;
import io.datarouter.bytes.binarydto.fieldcodec.BinaryDtoBaseFieldCodec;
import java.util.Arrays;

public class ByteArrayBinaryDtoFieldCodec
extends BinaryDtoBaseFieldCodec<byte[]> {
    @Override
    public byte[] encode(byte[] value) {
        byte[] sizeBytes = VarIntTool.encode(value.length);
        return ByteTool.concat(sizeBytes, value);
    }

    @Override
    public LengthAndValue<byte[]> decodeWithLength(byte[] bytes, int offset) {
        int cursor = offset;
        int size = VarIntTool.decodeInt(bytes, cursor);
        byte[] value = new byte[size];
        System.arraycopy(bytes, cursor += VarIntTool.length(size), value, 0, size);
        int length = (cursor += size) - offset;
        return new LengthAndValue<byte[]>(length, value);
    }

    @Override
    public int compareAsIfEncoded(byte[] left, byte[] right) {
        int sizeDiff = Integer.compare(left.length, right.length);
        if (sizeDiff != 0) {
            return sizeDiff;
        }
        return Arrays.compareUnsigned(left, right);
    }
}

