/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

public class ReplacingFunction<A, B>
implements Function<A, B> {
    private final Function<A, B> function;
    private final A valueToReplace;
    private final Supplier<B> replacementSupplier;

    private ReplacingFunction(Function<A, B> function, A valueToReplace, Supplier<B> replacementSupplier) {
        this.function = function;
        this.valueToReplace = valueToReplace;
        this.replacementSupplier = replacementSupplier;
    }

    @Override
    public B apply(A value) {
        if (Objects.equals(value, this.valueToReplace)) {
            return this.replacementSupplier.get();
        }
        return this.function.apply(value);
    }

    public static <A, B> ReplacingFunction<A, B> of(Function<A, B> function, A valueToReplace, Supplier<B> replacementSupplier) {
        return new ReplacingFunction<A, B>(function, valueToReplace, replacementSupplier);
    }

    public static class NullPassthroughFunction<A, B>
    extends NullReplacingFunction<A, B> {
        private NullPassthroughFunction(Function<A, B> function) {
            super(function, () -> null);
        }

        public static <A, B> NullPassthroughFunction<A, B> of(Function<A, B> function) {
            return new NullPassthroughFunction<A, B>(function);
        }
    }

    public static class NullReplacingFunction<A, B>
    extends ReplacingFunction<A, B> {
        private NullReplacingFunction(Function<A, B> function, Supplier<B> replacementSupplier) {
            super(function, null, replacementSupplier);
        }

        public static <A, B> NullReplacingFunction<A, B> of(Function<A, B> function, Supplier<B> replacementSupplier) {
            return new NullReplacingFunction<A, B>(function, replacementSupplier);
        }
    }
}

