/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.codec.list.intlist;

import io.datarouter.bytes.EmptyArray;
import io.datarouter.bytes.codec.intcodec.ComparableIntCodec;
import java.util.ArrayList;
import java.util.List;

public class IntListCodec {
    public static final IntListCodec INSTANCE = new IntListCodec();
    private static final ComparableIntCodec COMPARABLE_INT_CODEC = ComparableIntCodec.INSTANCE;
    private static final int ITEM_LENGTH = COMPARABLE_INT_CODEC.length();

    public byte[] encode(List<Integer> values) {
        if (values.size() == 0) {
            return EmptyArray.BYTE;
        }
        byte[] bytes = new byte[ITEM_LENGTH * values.size()];
        this.encode(values, bytes, 0);
        return bytes;
    }

    public int encode(List<Integer> values, byte[] bytes, int offset) {
        int cursor = offset;
        int i = 0;
        while (i < values.size()) {
            COMPARABLE_INT_CODEC.encode(values.get(i), bytes, cursor);
            cursor += ITEM_LENGTH;
            ++i;
        }
        return values.size() * ITEM_LENGTH;
    }

    public List<Integer> decode(byte[] bytes) {
        return this.decode(bytes, 0, bytes.length);
    }

    public List<Integer> decode(byte[] bytes, int offset, int bytesLength) {
        if (bytesLength == 0) {
            return new ArrayList<Integer>(0);
        }
        if (bytesLength % ITEM_LENGTH != 0) {
            throw new IllegalArgumentException("bytesLength must be multiple of " + ITEM_LENGTH);
        }
        int resultLength = bytesLength / ITEM_LENGTH;
        ArrayList<Integer> result = new ArrayList<Integer>(resultLength);
        int cursor = offset;
        int i = 0;
        while (i < resultLength) {
            int value = COMPARABLE_INT_CODEC.decode(bytes, cursor);
            cursor += ITEM_LENGTH;
            result.add(value);
            ++i;
        }
        return result;
    }
}

