/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.codec.stringcodec;

import io.datarouter.bytes.LengthAndValue;
import io.datarouter.bytes.codec.stringcodec.StringCodec;

public class TerminatedStringCodec {
    public static final TerminatedStringCodec US_ASCII = new TerminatedStringCodec(StringCodec.US_ASCII);
    public static final TerminatedStringCodec ISO_8859_1 = new TerminatedStringCodec(StringCodec.ISO_8859_1);
    public static final TerminatedStringCodec UTF_8 = new TerminatedStringCodec(StringCodec.UTF_8);
    private static final byte TERMINAL_BYTE = 0;
    private static final byte ESCAPE_BYTE = 1;
    private static final int ESCAPE_SHIFT = 2;
    private final StringCodec stringCodec;

    public TerminatedStringCodec(StringCodec stringCodec) {
        this.stringCodec = stringCodec;
    }

    public byte[] encode(String value) {
        byte[] encodedBytes = this.stringCodec.encode(value);
        return TerminatedStringCodec.escapeAndTerminate(encodedBytes);
    }

    public LengthAndValue<String> decode(byte[] bytes) {
        return this.decode(bytes, 0);
    }

    public LengthAndValue<String> decode(byte[] bytes, int offset) {
        NumEscapedAndTerminalIndex escapedCountAndTerminalIndex = TerminatedStringCodec.findEscapedCountAndTerminalIndex(bytes, offset);
        int numEscaped = escapedCountAndTerminalIndex.numEscaped;
        int terminalIndex = escapedCountAndTerminalIndex.terminalIndex;
        int consumedLength = terminalIndex - offset + 1;
        if (numEscaped == 0) {
            int escapedLength = terminalIndex - offset;
            String value = this.stringCodec.decode(bytes, offset, escapedLength);
            return new LengthAndValue<String>(consumedLength, value);
        }
        byte[] unescapedAndUnterminatedBytes = TerminatedStringCodec.unescapeAndUnterminate(bytes, offset, numEscaped, terminalIndex);
        String value = this.stringCodec.decode(unescapedAndUnterminatedBytes);
        return new LengthAndValue<String>(consumedLength, value);
    }

    private static boolean needsEscaping(byte bite) {
        return bite == 0 || bite == 1;
    }

    private static int numToEscape(byte[] encodedBytes) {
        int numToEscape = 0;
        int i = 0;
        while (i < encodedBytes.length) {
            if (TerminatedStringCodec.needsEscaping(encodedBytes[i])) {
                ++numToEscape;
            }
            ++i;
        }
        return numToEscape;
    }

    private static byte[] escapeAndTerminate(byte[] encodedBytes) {
        int numToEscape = TerminatedStringCodec.numToEscape(encodedBytes);
        if (numToEscape == 0) {
            return TerminatedStringCodec.terminate(encodedBytes);
        }
        int escapedLength = encodedBytes.length + numToEscape;
        int terminatedLength = escapedLength + 1;
        byte[] result = new byte[terminatedLength];
        int encodedIndex = 0;
        int escapedIndex = 0;
        while (escapedIndex < escapedLength) {
            byte byteI = encodedBytes[encodedIndex];
            if (TerminatedStringCodec.needsEscaping(encodedBytes[encodedIndex])) {
                result[escapedIndex] = 1;
                result[++escapedIndex] = (byte)(byteI + 2);
            } else {
                result[escapedIndex] = encodedBytes[encodedIndex];
            }
            ++encodedIndex;
            ++escapedIndex;
        }
        result[result.length - 1] = 0;
        return result;
    }

    private static byte[] terminate(byte[] encodedBytes) {
        int terminatedLength = encodedBytes.length + 1;
        byte[] result = new byte[terminatedLength];
        System.arraycopy(encodedBytes, 0, result, 0, encodedBytes.length);
        result[result.length - 1] = 0;
        return result;
    }

    private static NumEscapedAndTerminalIndex findEscapedCountAndTerminalIndex(byte[] bytes, int offset) {
        int numEscaped = 0;
        int index = offset;
        while (true) {
            if (bytes[index] == 1) {
                ++numEscaped;
            } else if (bytes[index] == 0) break;
            ++index;
        }
        return new NumEscapedAndTerminalIndex(numEscaped, index);
    }

    private static byte[] unescapeAndUnterminate(byte[] escapedBytes, int offset, int numEscaped, int terminalIndex) {
        int escapedLength = terminalIndex - offset;
        int unescapedLength = escapedLength - numEscaped;
        byte[] unescapedBytes = new byte[unescapedLength];
        int escapedIndex = offset;
        int unescapedIndex = 0;
        while (escapedIndex < terminalIndex) {
            unescapedBytes[unescapedIndex] = escapedBytes[escapedIndex] == 1 ? (byte)(escapedBytes[++escapedIndex] - 2) : escapedBytes[escapedIndex];
            ++escapedIndex;
            ++unescapedIndex;
        }
        return unescapedBytes;
    }

    private static class NumEscapedAndTerminalIndex {
        final int numEscaped;
        final int terminalIndex;

        public NumEscapedAndTerminalIndex(int numEscaped, int terminalIndex) {
            this.numEscaped = numEscaped;
            this.terminalIndex = terminalIndex;
        }
    }
}

