/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.codec.doublecodec;

import io.datarouter.bytes.codec.doublecodec.RawDoubleCodec;
import io.datarouter.bytes.codec.longcodec.RawLongCodec;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NullableRawDoubleCodec {
    private static final Logger logger = LoggerFactory.getLogger(NullableRawDoubleCodec.class);
    public static final NullableRawDoubleCodec INSTANCE = new NullableRawDoubleCodec();
    private static final long NaN = 0x10000000000000L;
    private static final long NULL = 0x10000000000000L;
    private static final RawDoubleCodec RAW_DOUBLE_CODEC = RawDoubleCodec.INSTANCE;
    private static final RawLongCodec RAW_LONG_CODEC = RawLongCodec.INSTANCE;
    private static final int LENGTH = RAW_DOUBLE_CODEC.length();
    private static final AtomicBoolean ENCODED_NULL = new AtomicBoolean(false);
    private static final AtomicBoolean DECODED_NULL = new AtomicBoolean(false);

    public int length() {
        return LENGTH;
    }

    public byte[] encode(Double value) {
        if (value == null && !ENCODED_NULL.getAndSet(true)) {
            logger.warn("", (Throwable)new Exception());
        }
        double nonNullValue = value == null ? Double.longBitsToDouble(0x10000000000000L) : value;
        return RAW_DOUBLE_CODEC.encode(nonNullValue);
    }

    public double decode(byte[] bytes) {
        return this.decode(bytes, 0);
    }

    public Double decode(byte[] bytes, int offset) {
        Double nullableValue;
        long nonNullValue = RAW_LONG_CODEC.decode(bytes, offset);
        Double d = nullableValue = nonNullValue == 0x10000000000000L ? null : Double.valueOf(Double.longBitsToDouble(nonNullValue));
        if (nullableValue == null && !DECODED_NULL.getAndSet(true)) {
            logger.warn("", (Throwable)new Exception());
        }
        return nullableValue;
    }
}

