/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.codec.array.floatarray;

import io.datarouter.bytes.EmptyArray;
import io.datarouter.bytes.codec.floatcodec.ComparableFloatCodec;

public class ComparableFloatArrayCodec {
    public static final ComparableFloatArrayCodec INSTANCE = new ComparableFloatArrayCodec();
    private static final ComparableFloatCodec COMPARABLE_FLOAT_CODEC = ComparableFloatCodec.INSTANCE;
    private static final int ITEM_LENGTH = COMPARABLE_FLOAT_CODEC.length();

    public int itemLength() {
        return ITEM_LENGTH;
    }

    public byte[] encode(float[] values) {
        if (values.length == 0) {
            return EmptyArray.BYTE;
        }
        byte[] bytes = new byte[ITEM_LENGTH * values.length];
        this.encode(values, bytes, 0);
        return bytes;
    }

    public int encode(float[] values, byte[] bytes, int offset) {
        int cursor = offset;
        int i = 0;
        while (i < values.length) {
            COMPARABLE_FLOAT_CODEC.encode(values[i], bytes, cursor);
            cursor += ITEM_LENGTH;
            ++i;
        }
        return values.length * ITEM_LENGTH;
    }

    public float[] decode(byte[] bytes) {
        return this.decode(bytes, 0, bytes.length);
    }

    public float[] decode(byte[] bytes, int offset, int bytesLength) {
        if (bytesLength == 0) {
            return EmptyArray.FLOAT;
        }
        if (bytesLength % ITEM_LENGTH != 0) {
            throw new IllegalArgumentException("bytesLength must be multiple of " + ITEM_LENGTH);
        }
        int resultLength = bytesLength / ITEM_LENGTH;
        float[] result = new float[resultLength];
        int cursor = offset;
        int i = 0;
        while (i < resultLength) {
            result[i] = COMPARABLE_FLOAT_CODEC.decode(bytes, cursor);
            cursor += ITEM_LENGTH;
            ++i;
        }
        return result;
    }
}

