/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.codec.time;

import io.datarouter.bytes.codec.intcodec.ComparableIntCodec;
import io.datarouter.bytes.codec.longcodec.ComparableLongCodec;
import java.time.Instant;

public class ComparableInstantCodec {
    public static final ComparableInstantCodec INSTANCE = new ComparableInstantCodec();
    private static final ComparableLongCodec LONG_CODEC = ComparableLongCodec.INSTANCE;
    private static final ComparableIntCodec INT_CODEC = ComparableIntCodec.INSTANCE;
    private static final int LENGTH = LONG_CODEC.length() + INT_CODEC.length();

    public int length() {
        return LENGTH;
    }

    public byte[] encode(Instant value) {
        byte[] bytes = new byte[LENGTH];
        this.encode(value, bytes, 0);
        return bytes;
    }

    public int encode(Instant value, byte[] bytes, int offset) {
        int cursor = offset;
        LONG_CODEC.encode(value.getEpochSecond(), bytes, cursor);
        INT_CODEC.encode(value.getNano(), bytes, cursor += LONG_CODEC.length());
        return LENGTH;
    }

    public Instant decode(byte[] bytes, int offset) {
        int cursor = offset;
        long epochSeconds = LONG_CODEC.decode(bytes, cursor);
        int nanos = INT_CODEC.decode(bytes, cursor += LONG_CODEC.length());
        return Instant.ofEpochSecond(epochSeconds, nanos);
    }
}

