/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.codec.longcodec;

import io.datarouter.bytes.codec.longcodec.RawLongCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UInt63Codec {
    private static final Logger logger = LoggerFactory.getLogger(UInt63Codec.class);
    public static final UInt63Codec INSTANCE = new UInt63Codec();
    private static final RawLongCodec RAW_CODEC = RawLongCodec.INSTANCE;
    private static final int LENGTH = RAW_CODEC.length();

    public int length() {
        return LENGTH;
    }

    public byte[] encode(long value) {
        byte[] bytes = new byte[LENGTH];
        this.encode(value, bytes, 0);
        return bytes;
    }

    public int encode(long value, byte[] bytes, int offset) {
        if (value < 0L && value != Long.MIN_VALUE) {
            logger.warn("", (Throwable)new IllegalArgumentException("no negatives: " + value));
        }
        return RAW_CODEC.encode(value, bytes, offset);
    }

    public long decode(byte[] bytes) {
        return this.decode(bytes, 0);
    }

    public long decode(byte[] bytes, int offset) {
        long value = RAW_CODEC.decode(bytes, offset);
        if (value < 0L && value != Long.MIN_VALUE) {
            logger.warn("", (Throwable)new IllegalArgumentException("no negatives: " + value));
        }
        return value;
    }
}

