/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.codec.list.intlist;

import io.datarouter.bytes.codec.intcodec.NullableComparableIntCodec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntListCodec {
    private static final Logger logger = LoggerFactory.getLogger(IntListCodec.class);
    public static final IntListCodec INSTANCE = new IntListCodec();
    private static final NullableComparableIntCodec NULLABLE_COMPARABLE_INT_CODEC = NullableComparableIntCodec.INSTANCE;
    private static final int ITEM_LENGTH = NULLABLE_COMPARABLE_INT_CODEC.length();

    public byte[] encode(List<Integer> values) {
        byte[] out = new byte[ITEM_LENGTH * values.size()];
        int i = 0;
        while (i < values.size()) {
            byte[] bytesNullable = NULLABLE_COMPARABLE_INT_CODEC.encode(values.get(i));
            logger.debug(Arrays.toString(bytesNullable));
            System.arraycopy(bytesNullable, 0, out, i * ITEM_LENGTH, ITEM_LENGTH);
            ++i;
        }
        logger.info(Arrays.toString(out));
        return out;
    }

    public List<Integer> decode(byte[] bytes, int offset) {
        int numValues = (bytes.length - offset) / ITEM_LENGTH;
        ArrayList<Integer> values = new ArrayList<Integer>(numValues);
        byte[] arrayToCopy = new byte[ITEM_LENGTH];
        int i = 0;
        while (i < numValues) {
            System.arraycopy(bytes, i * ITEM_LENGTH + offset, arrayToCopy, 0, ITEM_LENGTH);
            values.add(NULLABLE_COMPARABLE_INT_CODEC.decode(arrayToCopy, 0));
            ++i;
        }
        return values;
    }
}

