/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.codec.list.doublelist;

import io.datarouter.bytes.codec.doublecodec.NullableRawDoubleCodec;
import java.util.ArrayList;
import java.util.List;

public class DoubleListCodec {
    public static final DoubleListCodec INSTANCE = new DoubleListCodec();
    private static final NullableRawDoubleCodec NULLABLE_RAW_DOUBLE_CODEC = NullableRawDoubleCodec.INSTANCE;
    private static final int ITEM_LENGTH = NULLABLE_RAW_DOUBLE_CODEC.length();

    public byte[] encode(List<Double> values) {
        byte[] out = new byte[ITEM_LENGTH * values.size()];
        int i = 0;
        while (i < values.size()) {
            System.arraycopy(NULLABLE_RAW_DOUBLE_CODEC.encode(values.get(i)), 0, out, i * ITEM_LENGTH, ITEM_LENGTH);
            ++i;
        }
        return out;
    }

    public List<Double> decode(byte[] bytes, int offset) {
        int numValues = (bytes.length - offset) / ITEM_LENGTH;
        ArrayList<Double> values = new ArrayList<Double>(numValues);
        byte[] arrayToCopy = new byte[ITEM_LENGTH];
        int i = 0;
        while (i < numValues) {
            System.arraycopy(bytes, i * ITEM_LENGTH + offset, arrayToCopy, 0, ITEM_LENGTH);
            values.add(NULLABLE_RAW_DOUBLE_CODEC.decode(arrayToCopy, 0));
            ++i;
        }
        return values;
    }
}

