/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.binarydto.fieldcodec.array;

import io.datarouter.bytes.ByteTool;
import io.datarouter.bytes.LengthAndValue;
import io.datarouter.bytes.VarIntTool;
import io.datarouter.bytes.binarydto.fieldcodec.BinaryDtoBaseFieldCodec;
import io.datarouter.bytes.codec.array.booleanarray.ComparableBooleanArrayCodec;
import java.util.Arrays;

public class BooleanArrayBinaryDtoFieldCodec
extends BinaryDtoBaseFieldCodec<boolean[]> {
    private static final ComparableBooleanArrayCodec CODEC = ComparableBooleanArrayCodec.INSTANCE;

    @Override
    public byte[] encode(boolean[] value) {
        byte[] sizeBytes = VarIntTool.encode(value.length);
        byte[] valueBytes = CODEC.encode(value);
        return ByteTool.concat(sizeBytes, valueBytes);
    }

    @Override
    public LengthAndValue<boolean[]> decodeWithLength(byte[] bytes, int offset) {
        int cursor = offset;
        int size = VarIntTool.decodeInt(bytes, cursor);
        int bytesLength = size * CODEC.itemLength();
        boolean[] value = CODEC.decode(bytes, cursor += VarIntTool.length(size), bytesLength);
        int length = (cursor += bytesLength) - offset;
        return new LengthAndValue<boolean[]>(length, value);
    }

    @Override
    public int compareAsIfEncoded(boolean[] left, boolean[] right) {
        int sizeDiff = Integer.compare(left.length, right.length);
        if (sizeDiff != 0) {
            return sizeDiff;
        }
        return Arrays.compare(left, right);
    }
}

