/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.binarydto.fieldcodec;

import io.datarouter.bytes.Codec;
import io.datarouter.bytes.FunctionalCodec;
import io.datarouter.bytes.LengthAndValue;
import io.datarouter.bytes.binarydto.fieldcodec.BinaryDtoBaseFieldCodec;
import java.util.function.Function;

public class BinaryDtoConvertingFieldCodec<R, T>
extends BinaryDtoBaseFieldCodec<R> {
    private final Codec<R, T> converter;
    private final BinaryDtoBaseFieldCodec<T> codec;

    public BinaryDtoConvertingFieldCodec(Function<R, T> convertTo, Function<T, R> convertFrom, BinaryDtoBaseFieldCodec<T> codec) {
        this.converter = new FunctionalCodec<R, T>(convertTo, convertFrom);
        this.codec = codec;
    }

    public BinaryDtoConvertingFieldCodec(Codec<R, T> converter, BinaryDtoBaseFieldCodec<T> codec) {
        this.converter = converter;
        this.codec = codec;
    }

    @Override
    public boolean isFixedLength() {
        return this.codec.isFixedLength();
    }

    @Override
    public int fixedLength() {
        return this.codec.fixedLength();
    }

    @Override
    public byte[] encode(R value) {
        T convertedValue = this.converter.encode(value);
        return this.codec.encode(convertedValue);
    }

    @Override
    public R decode(byte[] bytes, int offset) {
        T rawValue = this.codec.decode(bytes, offset);
        return this.converter.decode(rawValue);
    }

    @Override
    public LengthAndValue<R> decodeWithLength(byte[] bytes, int offset) {
        LengthAndValue<T> rawLengthAndValue = this.codec.decodeWithLength(bytes, offset);
        R convertedValue = this.converter.decode(rawLengthAndValue.value);
        return new LengthAndValue<R>(rawLengthAndValue.length, convertedValue);
    }
}

