/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes;

import io.datarouter.bytes.codec.bytestringcodec.Base2ByteStringCodec;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;

public class VarIntTool {
    private static final byte BYTE_7_RIGHT_BITS_SET = 127;
    private static final long LONG_7_RIGHT_BITS_SET = 127L;
    private static final long LONG_8TH_BIT_SET = 128L;

    public static int length(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("must be positive");
        }
        if (value == 0L) {
            return 1;
        }
        return (70 - Long.numberOfLeadingZeros(value)) / 7;
    }

    public static byte[] encode(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("must be positive");
        }
        int numBytes = VarIntTool.length(value);
        byte[] bytes = new byte[numBytes];
        long remainder = value;
        int i = 0;
        while (i < numBytes - 1) {
            bytes[i] = (byte)(remainder & 0x7FL | 0x80L);
            remainder >>= 7;
            ++i;
        }
        bytes[numBytes - 1] = (byte)(remainder & 0x7FL);
        return bytes;
    }

    public static long decodeLong(byte[] bytes, int offset) {
        if (offset >= bytes.length) {
            throw new IllegalArgumentException("invalid bytes " + Base2ByteStringCodec.INSTANCE.encode(bytes));
        }
        long value = 0L;
        int i = 0;
        while (true) {
            byte byteVar = bytes[i + offset];
            long shifted = 0x7F & bytes[i + offset];
            value |= (shifted <<= 7 * i);
            if (byteVar >= 0) break;
            ++i;
        }
        return value;
    }

    public static long decodeLong(byte[] bytes) {
        return VarIntTool.decodeLong(bytes, 0);
    }

    public static int decodeInt(byte[] bytes, int offset) {
        return (int)VarIntTool.decodeLong(bytes, offset);
    }

    public static int decodeInt(byte[] bytes) {
        return VarIntTool.decodeInt(bytes, 0);
    }

    public static Optional<Long> fromInputStream(InputStream is) {
        return VarIntTool.nextBytes(is).map(VarIntTool::decodeLong);
    }

    private static Optional<byte[]> nextBytes(InputStream is) {
        int byteVar;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        do {
            try {
                byteVar = is.read();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (byteVar == -1) {
                return Optional.empty();
            }
            baos.write(byteVar);
        } while (byteVar >= 128);
        return Optional.of(baos.toByteArray());
    }
}

