/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs.service;

import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.ListQueuesResult;
import com.amazonaws.services.sqs.model.QueueDoesNotExistException;
import io.datarouter.aws.sqs.BaseSqsNode;
import io.datarouter.aws.sqs.SqsClientManager;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.node.DatarouterNodes;
import io.datarouter.storage.node.NodeTool;
import io.datarouter.util.string.StringTool;
import io.datarouter.util.tuple.Pair;
import io.datarouter.util.tuple.Twin;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class SqsQueueRegistryService {
    @Inject
    private DatarouterNodes nodes;
    @Inject
    private SqsClientManager sqsClientManager;

    public Pair<List<Twin<String>>, List<String>> getSqsQueuesForClient(ClientId clientId) {
        HashSet knownQueuesUrls = new HashSet();
        AmazonSQS sqs = this.sqsClientManager.getAmazonSqs(clientId);
        List sqsNodes = Scanner.of((Iterable)this.nodes.getPhysicalNodesForClient(clientId.getName())).map(NodeTool::extractSinglePhysicalNode).map(physicalNode -> (BaseSqsNode)((Object)physicalNode)).list();
        List knownQueueUrlByName = Scanner.of((Iterable)sqsNodes).map(BaseSqsNode::getQueueUrlAndName).map(Supplier::get).each(twin -> {
            boolean bl = knownQueuesUrls.add((String)twin.getLeft());
        }).list();
        List unreferencedQueues = Scanner.of((Iterable)sqsNodes).map(BaseSqsNode::getOrBuildFullNamespace).distinct().map(arg_0 -> ((AmazonSQS)sqs).listQueues(arg_0)).concatIter(ListQueuesResult::getQueueUrls).exclude(knownQueuesUrls::contains).map(queueUrl -> StringTool.getStringAfterLastOccurrence((String)"/", (String)queueUrl)).include(queueName -> this.sqsQueueExists(sqs, (String)queueName)).list();
        return new Pair((Object)knownQueueUrlByName, (Object)unreferencedQueues);
    }

    private boolean sqsQueueExists(AmazonSQS sqs, String queueName) {
        try {
            sqs.getQueueUrl(queueName);
            return true;
        }
        catch (QueueDoesNotExistException e) {
            return false;
        }
    }
}

