/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs.web.handler;

import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.GetQueueUrlResult;
import com.amazonaws.services.sqs.model.PurgeQueueRequest;
import com.amazonaws.services.sqs.model.QueueDoesNotExistException;
import io.datarouter.aws.sqs.SqsClientManager;
import io.datarouter.instrumentation.changelog.ChangelogRecorder;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.DatarouterClients;
import io.datarouter.util.concurrent.ThreadTool;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.handler.types.Param;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4PageFactory;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.ATag;
import j2html.tags.specialized.DivTag;
import java.time.Duration;
import javax.inject.Inject;

public class SqsUpdateQueueHandler
extends BaseHandler {
    public static final String PARAM_clientName = "clientName";
    public static final String PARAM_queueName = "queueName";
    public static final String PARAM_referer = "referer";
    @Inject
    private ChangelogRecorder changelogRecorder;
    @Inject
    private SqsClientManager sqsClientManager;
    @Inject
    private DatarouterClients datarouterClients;
    @Inject
    private Bootstrap4PageFactory pageFactory;

    @BaseHandler.Handler
    private Mav deleteQueue(@Param(value="clientName") String clientName, @Param(value="queueName") String queueName, @Param(value="referer") String referer) {
        ClientId clientId = this.datarouterClients.getClientId(clientName);
        AmazonSQS sqs = this.sqsClientManager.getAmazonSqs(clientId);
        GetQueueUrlResult queueUrlResult = sqs.getQueueUrl(queueName);
        sqs.deleteQueue(queueUrlResult.getQueueUrl());
        String message = "Deleted unreferenced SQS queue: " + queueName;
        ChangelogRecorder.DatarouterChangelogDto dto = new ChangelogRecorder.DatarouterChangelogDtoBuilder("Sqs", queueName, "deleteQueue", this.getSessionInfo().getRequiredSession().getUsername()).build();
        while (this.sqsQueueExists(sqs, queueName)) {
            ThreadTool.trySleep((long)Duration.ofSeconds(15L).toMillis());
        }
        this.changelogRecorder.record(dto);
        return this.buildPage(referer, message);
    }

    @BaseHandler.Handler
    private Mav purgeQueue(@Param(value="clientName") String clientName, @Param(value="queueName") String queueName, @Param(value="referer") String referer) {
        ClientId clientId = this.datarouterClients.getClientId(clientName);
        AmazonSQS sqs = this.sqsClientManager.getAmazonSqs(clientId);
        GetQueueUrlResult queueUrlResult = sqs.getQueueUrl(queueName);
        sqs.purgeQueue(new PurgeQueueRequest(queueUrlResult.getQueueUrl()));
        String message = "Purged SQS queue: " + queueName;
        ChangelogRecorder.DatarouterChangelogDto dto = new ChangelogRecorder.DatarouterChangelogDtoBuilder("Sqs", queueName, "purgeQueue", this.getSessionInfo().getRequiredSession().getUsername()).build();
        this.changelogRecorder.record(dto);
        return this.buildPage(referer, message);
    }

    private boolean sqsQueueExists(AmazonSQS sqs, String queueName) {
        try {
            sqs.getQueueUrl(queueName);
            return true;
        }
        catch (QueueDoesNotExistException e) {
            return false;
        }
    }

    private Mav buildPage(String href, String message) {
        DivTag backButton = TagCreator.div((DomContent[])new DomContent[]{((ATag)((ATag)TagCreator.a((DomContent[])new DomContent[]{TagCreator.i().withClass("fas fa-angle-left")}).withText("Go back to client details")).withHref(href)).withClass("btn btn-primary")});
        DivTag content = (DivTag)TagCreator.div((DomContent[])new DomContent[]{backButton, TagCreator.div((String)message).withClass("my-4")}).withClass("container my-4");
        return this.pageFactory.startBuilder(this.request).withContent((DomContent)content).withTitle("Update Sqs Queue").buildMav();
    }
}

