/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs.web;

import com.amazonaws.services.sqs.model.QueueAttributeName;
import io.datarouter.aws.sqs.BaseSqsNode;
import io.datarouter.aws.sqs.SqsClientManager;
import io.datarouter.aws.sqs.SqsClientType;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientOptions;
import io.datarouter.storage.node.DatarouterNodes;
import io.datarouter.storage.node.NodeTool;
import io.datarouter.util.number.NumberFormatter;
import io.datarouter.util.number.NumberTool;
import io.datarouter.web.browse.DatarouterClientWebInspector;
import io.datarouter.web.browse.dto.DatarouterWebRequestParamsFactory;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.handler.mav.imp.MessageMav;
import io.datarouter.web.handler.params.Params;
import io.datarouter.web.html.j2html.J2HtmlLegendTable;
import io.datarouter.web.html.j2html.J2HtmlTable;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4PageFactory;
import io.datarouter.web.requirejs.DatarouterWebRequireJsV2;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.H4Tag;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;

public class SqsWebInspector
implements DatarouterClientWebInspector {
    @Inject
    private DatarouterNodes nodes;
    @Inject
    private DatarouterWebRequestParamsFactory paramsFactory;
    @Inject
    private SqsClientManager sqsClientManager;
    @Inject
    private Bootstrap4PageFactory pageFactory;
    @Inject
    private ClientOptions clientOptions;

    public Mav inspectClient(Params params, HttpServletRequest request) {
        DatarouterWebRequestParamsFactory datarouterWebRequestParamsFactory = this.paramsFactory;
        datarouterWebRequestParamsFactory.getClass();
        DatarouterWebRequestParamsFactory.DatarouterWebRequestParams clientParams = new DatarouterWebRequestParamsFactory.DatarouterWebRequestParams(datarouterWebRequestParamsFactory, params, SqsClientType.class);
        ClientId clientId = clientParams.getClientId();
        if (clientId == null) {
            return new MessageMav("Client not found");
        }
        String clientName = clientId.getName();
        Map allClientOptions = this.clientOptions.getAllClientOptions(clientName);
        DivTag content = (DivTag)TagCreator.div((DomContent[])new DomContent[]{this.buildClientPageHeader(clientName), this.buildClientOptionsTable(allClientOptions), this.buildQueueNodeTable(clientId), this.buildReferenceTable()}).withClass("container my-3");
        return this.pageFactory.startBuilder(request).withTitle("Datarouter Client - SQS").withRequires(new String[]{DatarouterWebRequireJsV2.SORTTABLE}).withContent((ContainerTag)content).buildMav();
    }

    private ContainerTag<?> buildQueueNodeTable(ClientId clientId) {
        List queueStatsRows = this.nodes.getPhysicalNodesForClient(clientId.getName()).stream().map(NodeTool::extractSinglePhysicalNode).map(physicalNode -> (BaseSqsNode)((Object)physicalNode)).map(BaseSqsNode::getQueueUrlAndName).map(Supplier::get).map(queueUrlAndName -> {
            String queueName = (String)queueUrlAndName.getRight();
            String queueUrl = (String)queueUrlAndName.getLeft();
            Map<String, String> attributesMap = this.sqsClientManager.getAllQueueAttributes(clientId, queueUrl);
            return new SqsWebInspectorDto(queueName, attributesMap.get(QueueAttributeName.ApproximateNumberOfMessages.name()), attributesMap.get(QueueAttributeName.ApproximateNumberOfMessagesDelayed.name()), attributesMap.get(QueueAttributeName.ApproximateNumberOfMessagesNotVisible.name()));
        }).sorted(Comparator.comparing(dto -> dto.queueName)).collect(Collectors.toList());
        ContainerTag table = new J2HtmlTable().withClasses(new String[]{"sortable table table-sm table-striped my-4 border"}).withColumn("Queue Name", row -> row.queueName).withColumn("Messages Available For Retrieval", row -> row.messagesAvailableForRetrieval).withColumn("Messages Delayed", row -> row.messagesDelayed).withColumn("Messages InFlight", row -> row.messagesInFlight).withColumn("Total Messages (Available + InFlight)", SqsWebInspectorDto::getTotalMessagesAvailable).build(queueStatsRows);
        H4Tag header = TagCreator.h4((String)"Queues");
        return (ContainerTag)((DivTag)TagCreator.div((DomContent[])new DomContent[]{header, table}).withClass("container-fluid my-4")).withStyle("padding-left: 0px");
    }

    private ContainerTag<?> buildReferenceTable() {
        return new J2HtmlLegendTable().withHeader("Legend").withClass("sortable table table-sm my-4 border").withEntry("Messages Available For Retrieval", "The approximate number of messages available for retrieval from the queue").withEntry("Messages Delayed", "The approximate number of messages in the queue that are delayed and not available for reading immediately. This can happen when the queue is configured as a delay queue or when a message has been sent with a delay parameter.").withEntry("Messages In Flight", "Messages are considered to be in flight if they have been sent to a client but have not yet been deleted or have not yet reached the end of their visibility window.").build();
    }

    private static class SqsWebInspectorDto {
        private final String queueName;
        private final String messagesAvailableForRetrieval;
        private final String messagesDelayed;
        private final String messagesInFlight;

        public SqsWebInspectorDto(String queueName, String messagesAvailableForRetrieval, String messagesDelayed, String messagesInFlight) {
            this.queueName = queueName;
            this.messagesAvailableForRetrieval = messagesAvailableForRetrieval;
            this.messagesDelayed = messagesDelayed;
            this.messagesInFlight = messagesInFlight;
        }

        public String getTotalMessagesAvailable() {
            long available = NumberTool.getLongNullSafe((String)this.messagesAvailableForRetrieval, (Long)0L);
            long inFlight = NumberTool.getLongNullSafe((String)this.messagesInFlight, (Long)0L);
            long total = available + inFlight;
            return NumberFormatter.addCommas((Number)total);
        }
    }
}

