/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs.op;

import com.amazonaws.AbortedException;
import com.amazonaws.services.sqs.model.DeleteMessageRequest;
import io.datarouter.aws.sqs.BaseSqsNode;
import io.datarouter.aws.sqs.SqsClientManager;
import io.datarouter.aws.sqs.op.SqsOp;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.queue.QueueMessageKey;
import io.datarouter.util.bytes.StringByteTool;
import io.datarouter.util.concurrent.UncheckedInterruptedException;

public class SqsAckOp<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>>
extends SqsOp<PK, D, F, Void> {
    private final QueueMessageKey key;
    private final SqsClientManager sqsClientManager;
    private final ClientId clientId;

    public SqsAckOp(QueueMessageKey key, Config config, BaseSqsNode<PK, D, F> sqsNode, SqsClientManager sqsClientManager, ClientId clientId) {
        super(config, sqsNode);
        this.key = key;
        this.sqsClientManager = sqsClientManager;
        this.clientId = clientId;
    }

    @Override
    protected Void run() {
        String handle = StringByteTool.fromUtf8Bytes((byte[])this.key.getHandle());
        DeleteMessageRequest deleteRequest = new DeleteMessageRequest(this.queueUrl, handle);
        try {
            this.sqsClientManager.getAmazonSqs(this.clientId).deleteMessage(deleteRequest);
        }
        catch (AbortedException e) {
            throw new UncheckedInterruptedException("", (Exception)((Object)e));
        }
        return null;
    }
}

