/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs;

import io.datarouter.aws.sqs.BaseSqsNode;
import io.datarouter.aws.sqs.SqsClientManager;
import io.datarouter.aws.sqs.group.op.SqsGroupPeekMultiOp;
import io.datarouter.aws.sqs.group.op.SqsGroupPutMultiOp;
import io.datarouter.aws.sqs.op.SqsAckMultiOp;
import io.datarouter.aws.sqs.op.SqsAckOp;
import io.datarouter.aws.sqs.op.SqsOp;
import io.datarouter.aws.sqs.single.op.SqsPeekMultiOp;
import io.datarouter.aws.sqs.single.op.SqsPutMultiOp;
import io.datarouter.aws.sqs.single.op.SqsPutOp;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.queue.GroupQueueMessage;
import io.datarouter.storage.queue.QueueMessage;
import io.datarouter.storage.queue.QueueMessageKey;
import java.util.Collection;
import java.util.List;

public class SqsOpFactory<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> {
    private final BaseSqsNode<PK, D, F> sqsNode;
    private final SqsClientManager sqsClientManager;
    private final ClientId clientId;

    public SqsOpFactory(BaseSqsNode<PK, D, F> sqsNode, SqsClientManager sqsClientManager, ClientId clientId) {
        this.sqsNode = sqsNode;
        this.sqsClientManager = sqsClientManager;
        this.clientId = clientId;
    }

    public SqsOp<PK, D, F, List<QueueMessage<PK, D>>> makePeekMultiOp(Config config) {
        return new SqsPeekMultiOp<PK, D, F>(config, this.sqsNode, this.sqsClientManager, this.clientId);
    }

    public SqsOp<PK, D, F, Void> makeAckMultiOp(Collection<QueueMessageKey> keys, Config config) {
        return new SqsAckMultiOp<PK, D, F>(keys, config, this.sqsNode, this.sqsClientManager, this.clientId);
    }

    public SqsOp<PK, D, F, Void> makePutMultiOp(Collection<D> databeans, Config config) {
        return new SqsPutMultiOp<PK, D, F>(databeans, config, this.sqsNode, this.sqsClientManager, this.clientId);
    }

    public SqsOp<PK, D, F, Void> makePutOp(D databean, Config config) {
        return new SqsPutOp<PK, D, F>(databean, config, this.sqsNode, this.sqsClientManager, this.clientId);
    }

    public SqsOp<PK, D, F, Void> makeAckOp(QueueMessageKey key, Config config) {
        return new SqsAckOp<PK, D, F>(key, config, this.sqsNode, this.sqsClientManager, this.clientId);
    }

    public SqsOp<PK, D, F, Void> makeGroupPutMultiOp(Collection<D> databeans, Config config) {
        return new SqsGroupPutMultiOp<PK, D, F>(databeans, config, this.sqsNode, this.sqsClientManager, this.clientId);
    }

    public SqsOp<PK, D, F, List<GroupQueueMessage<PK, D>>> makeGroupPeekMultiOp(Config config) {
        return new SqsGroupPeekMultiOp<PK, D, F>(config, this.sqsNode, this.sqsClientManager, this.clientId);
    }
}

