/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs;

import io.datarouter.aws.sqs.SqsNodeFactory;
import io.datarouter.aws.sqs.group.SqsGroupNode;
import io.datarouter.aws.sqs.single.SqsNode;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.entity.Entity;
import io.datarouter.model.key.entity.EntityKey;
import io.datarouter.model.key.primary.EntityPrimaryKey;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.client.imp.BaseClientNodeFactory;
import io.datarouter.storage.client.imp.QueueClientNodeFactory;
import io.datarouter.storage.client.imp.WrappedNodeFactory;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.adapter.counter.physical.PhysicalGroupQueueStorageCounterAdapter;
import io.datarouter.storage.node.adapter.counter.physical.PhysicalQueueStorageCounterAdapter;
import io.datarouter.storage.node.adapter.sanitization.physical.PhysicalGroupQueueStorageSanitizationAdapter;
import io.datarouter.storage.node.adapter.sanitization.physical.PhysicalQueueStorageSanitizationAdapter;
import io.datarouter.storage.node.adapter.trace.physical.PhysicalGroupQueueStorageTraceAdapter;
import io.datarouter.storage.node.adapter.trace.physical.PhysicalQueueStorageTraceAdapter;
import io.datarouter.storage.node.entity.EntityNodeParams;
import io.datarouter.storage.node.op.raw.GroupQueueStorage;
import io.datarouter.storage.node.op.raw.QueueStorage;
import io.datarouter.storage.node.type.physical.PhysicalNode;
import java.util.Arrays;
import java.util.List;
import java.util.function.UnaryOperator;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class SqsClientNodeFactory
extends BaseClientNodeFactory
implements QueueClientNodeFactory {
    @Inject
    private SqsNodeFactory sqsNodeFactory;

    public <EK extends EntityKey<EK>, E extends Entity<EK>, PK extends EntityPrimaryKey<EK, PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> WrappedNodeFactory<EK, E, PK, D, F, QueueStorage.PhysicalQueueStorageNode<PK, D, F>> makeWrappedNodeFactory() {
        return new SqsWrappedNodeFactory();
    }

    public <PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> PhysicalNode<PK, D, F> createSingleQueueNode(NodeParams<PK, D, F> nodeParams) {
        SqsNode<PK, D, F> node = this.sqsNodeFactory.createSingleNode(nodeParams);
        return new PhysicalQueueStorageTraceAdapter((QueueStorage.PhysicalQueueStorageNode)new PhysicalQueueStorageCounterAdapter((QueueStorage.PhysicalQueueStorageNode)new PhysicalQueueStorageSanitizationAdapter(node)));
    }

    public <PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> PhysicalNode<PK, D, F> createGroupQueueNode(NodeParams<PK, D, F> nodeParams) {
        SqsGroupNode<PK, D, F> node = this.sqsNodeFactory.createGroupNode(nodeParams);
        return new PhysicalGroupQueueStorageTraceAdapter((GroupQueueStorage.PhysicalGroupQueueStorageNode)new PhysicalGroupQueueStorageCounterAdapter((GroupQueueStorage.PhysicalGroupQueueStorageNode)new PhysicalGroupQueueStorageSanitizationAdapter(node)));
    }

    public class SqsWrappedNodeFactory<EK extends EntityKey<EK>, E extends Entity<EK>, PK extends EntityPrimaryKey<EK, PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>>
    extends WrappedNodeFactory<EK, E, PK, D, F, QueueStorage.PhysicalQueueStorageNode<PK, D, F>> {
        public QueueStorage.PhysicalQueueStorageNode<PK, D, F> createNode(EntityNodeParams<EK, E> entityNodeParams, NodeParams<PK, D, F> nodeParams) {
            return SqsClientNodeFactory.this.sqsNodeFactory.createSingleNode(nodeParams);
        }

        public List<UnaryOperator<QueueStorage.PhysicalQueueStorageNode<PK, D, F>>> getAdapters() {
            return Arrays.asList(PhysicalQueueStorageCounterAdapter::new, PhysicalQueueStorageSanitizationAdapter::new, PhysicalQueueStorageTraceAdapter::new);
        }
    }
}

