/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs.job;

import com.amazonaws.services.sqs.model.QueueAttributeName;
import io.datarouter.aws.sqs.BaseSqsNode;
import io.datarouter.aws.sqs.SqsClientManager;
import io.datarouter.aws.sqs.SqsClientType;
import io.datarouter.aws.sqs.SqsMetrics;
import io.datarouter.instrumentation.task.TaskTracker;
import io.datarouter.job.BaseJob;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientInitializationTracker;
import io.datarouter.storage.client.DatarouterClients;
import io.datarouter.storage.node.DatarouterNodes;
import io.datarouter.storage.node.NodeTool;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;

public class SqsQueuesLengthMonitoringJob
extends BaseJob {
    private static final String QUEUE_LENGTH_ATTRIBUTE = QueueAttributeName.ApproximateNumberOfMessages.name();
    private static final List<String> QUEUE_LENGTH_ATTRIBUTE_AS_LIST = Collections.singletonList(QUEUE_LENGTH_ATTRIBUTE);
    @Inject
    private DatarouterClients datarouterClients;
    @Inject
    private DatarouterNodes datarouterNodes;
    @Inject
    private SqsClientManager sqsClientManager;
    @Inject
    private ClientInitializationTracker clientInitializationTracker;
    @Inject
    private SqsMetrics metrics;

    public void run(TaskTracker tracker) {
        this.getInitializedSqsClients().collect(Collectors.toMap(Function.identity(), this::getSqsNodesForClient)).forEach(this::getQueueLengthAndSaveAsMetric);
    }

    private Stream<ClientId> getInitializedSqsClients() {
        return this.clientInitializationTracker.getInitializedClients().stream().filter(clientId -> this.datarouterClients.getClientTypeInstance(clientId) instanceof SqsClientType);
    }

    private List<BaseSqsNode<?, ?, ?>> getSqsNodesForClient(ClientId clientId) {
        return this.datarouterNodes.getPhysicalNodesForClient(clientId.getName()).stream().map(NodeTool::extractSinglePhysicalNode).map(physicalNode -> (BaseSqsNode)((Object)physicalNode)).collect(Collectors.toList());
    }

    private void getQueueLengthAndSaveAsMetric(ClientId clientId, List<BaseSqsNode<?, ?, ?>> sqsNodes) {
        sqsNodes.forEach(baseSqsNode -> {
            String queueUrl = (String)baseSqsNode.getQueueUrl().get();
            String queueName = queueUrl.substring(queueUrl.lastIndexOf(47) + 1);
            String queueLengthString = this.sqsClientManager.getQueueAttributes(clientId, queueUrl, QUEUE_LENGTH_ATTRIBUTE_AS_LIST).get(QUEUE_LENGTH_ATTRIBUTE);
            long queueLength = Long.parseLong(queueLengthString);
            this.metrics.saveSqsQueueLength(queueName, queueLength);
        });
    }
}

