/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs.job;

import com.amazonaws.services.sqs.model.QueueAttributeName;
import io.datarouter.aws.sqs.SqsClientManager;
import io.datarouter.aws.sqs.SqsClientType;
import io.datarouter.aws.sqs.SqsPhysicalNode;
import io.datarouter.aws.sqs.service.QueueUrlAndName;
import io.datarouter.instrumentation.task.TaskTracker;
import io.datarouter.job.BaseJob;
import io.datarouter.scanner.WarnOnModifyList;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientInitializationTracker;
import io.datarouter.storage.client.DatarouterClients;
import io.datarouter.storage.node.DatarouterNodes;
import io.datarouter.storage.node.NodeTool;
import io.datarouter.storage.util.DatarouterQueueMetrics;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqsMonitoringJob
extends BaseJob {
    private static final Logger logger = LoggerFactory.getLogger(SqsMonitoringJob.class);
    @Inject
    private DatarouterClients datarouterClients;
    @Inject
    private DatarouterNodes datarouterNodes;
    @Inject
    private SqsClientManager sqsClientManager;
    @Inject
    private ClientInitializationTracker clientInitializationTracker;

    public void run(TaskTracker tracker) {
        this.clientInitializationTracker.getInitializedClients().stream().filter(clientId -> this.datarouterClients.getClientTypeInstance(clientId) instanceof SqsClientType).forEach(clientId -> {
            Collection nodes = this.datarouterNodes.getPhysicalNodesForClient(clientId.getName());
            List queueUrlAndNames = (List)nodes.stream().map(NodeTool::extractSinglePhysicalNode).map(physicalNode -> (SqsPhysicalNode)physicalNode).peek($ -> {
                TaskTracker taskTracker2 = tracker.increment();
            }).map(SqsPhysicalNode::getQueueUrlAndName).map(Supplier::get).collect(WarnOnModifyList.deprecatedCollector());
            this.saveUnackedMessageAgeMetricForQueues((ClientId)clientId, (List)queueUrlAndNames.stream().map(QueueUrlAndName::queueName).collect(WarnOnModifyList.deprecatedCollector()));
            queueUrlAndNames.forEach(queueUrlAndName -> {
                try {
                    this.getQueueLengthAndSaveAsMetric((QueueUrlAndName)queueUrlAndName, (ClientId)clientId);
                }
                catch (RuntimeException e) {
                    logger.warn("failed to get attribute for queue=" + queueUrlAndName.queueName(), (Throwable)e);
                }
            });
        });
    }

    private void saveUnackedMessageAgeMetricForQueues(ClientId clientId, List<String> queueNames) {
        this.sqsClientManager.getApproximateAgeOfOldestUnackedMessageSecondsGroup(clientId, queueNames).entrySet().forEach(entry -> DatarouterQueueMetrics.saveOldestAckMessageAge((String)((String)entry.getKey()), (long)((Long)entry.getValue()), (String)"sqs"));
    }

    private void getQueueLengthAndSaveAsMetric(QueueUrlAndName queueUrlAndName, ClientId clientId) {
        String queueLengthString = this.sqsClientManager.getQueueAttribute(clientId, queueUrlAndName.queueUrl(), QueueAttributeName.ApproximateNumberOfMessages);
        long queueLength = Long.parseLong(queueLengthString);
        DatarouterQueueMetrics.saveQueueLength((String)queueUrlAndName.queueName(), (long)queueLength, (String)"sqs");
    }
}

