/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs;

import io.datarouter.aws.sqs.SqsClientManager;
import io.datarouter.aws.sqs.SqsClientType;
import io.datarouter.aws.sqs.SqsQueueNameService;
import io.datarouter.aws.sqs.blob.SqsBlobNode;
import io.datarouter.aws.sqs.group.SqsGroupNode;
import io.datarouter.aws.sqs.single.SqsNode;
import io.datarouter.bytes.Codec;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.databean.EmptyDatabean;
import io.datarouter.model.key.EmptyDatabeanKey;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.op.raw.BlobQueueStorage;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;

@Singleton
public class SqsNodeFactory {
    @Inject
    private SqsQueueNameService sqsQueueNameService;
    @Inject
    private SqsClientType sqsClientType;
    @Inject
    private SqsClientManager sqsClientManager;

    public <PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> SqsNode<PK, D, F> createSingleNode(NodeParams<PK, D, F> params) {
        return new SqsNode<PK, D, F>(this.sqsQueueNameService, params, this.sqsClientType, this.sqsClientManager, params.getClientId());
    }

    public <PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> SqsGroupNode<PK, D, F> createGroupNode(NodeParams<PK, D, F> params) {
        return new SqsGroupNode<PK, D, F>(this.sqsQueueNameService, params, this.sqsClientType, this.sqsClientManager, params.getClientId());
    }

    public <T> BlobQueueStorage.PhysicalBlobQueueStorageNode<T> createBlobQueueNode(NodeParams<EmptyDatabeanKey, EmptyDatabean, EmptyDatabean.EmptyDatabeanFielder> params, Codec<T, byte[]> codec) {
        return new SqsBlobNode<T>(this.sqsQueueNameService, params, codec, this.sqsClientType, this.sqsClientManager);
    }
}

