/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs;

import com.amazonaws.services.sqs.model.CreateQueueRequest;
import com.amazonaws.services.sqs.model.QueueAttributeName;
import io.datarouter.aws.sqs.SqsClientManager;
import io.datarouter.aws.sqs.SqsClientType;
import io.datarouter.aws.sqs.SqsOpFactory;
import io.datarouter.aws.sqs.SqsPhysicalNode;
import io.datarouter.aws.sqs.SqsQueueNameService;
import io.datarouter.aws.sqs.service.QueueUrlAndName;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientType;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.op.raw.write.QueueStorageWriter;
import io.datarouter.storage.node.type.physical.base.BasePhysicalNode;
import io.datarouter.storage.queue.QueueMessageKey;
import io.datarouter.util.singletonsupplier.SingletonSupplier;
import java.time.Duration;
import java.util.Collection;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSqsNode<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>>
extends BasePhysicalNode<PK, D, F>
implements QueueStorageWriter<PK, D>,
SqsPhysicalNode<PK, D, F> {
    private static final Logger logger = LoggerFactory.getLogger(BaseSqsNode.class);
    public static final int MAX_MESSAGES_PER_BATCH = 10;
    public static final Duration MAX_TIMEOUT = Duration.ofSeconds(20L);
    public static final long DEFAULT_VISIBILITY_TIMEOUT_MS = Duration.ofSeconds(30L).toMillis();
    public static final long RETENTION_S = Duration.ofDays(14L).getSeconds();
    private final String queueName;
    private final NodeParams<PK, D, F> params;
    private final Supplier<QueueUrlAndName> queueUrlAndName;
    private final SqsClientManager sqsClientManager;
    private final ClientId clientId;
    protected final SqsOpFactory<PK, D, F> sqsOpFactory;
    private final boolean owned;

    public BaseSqsNode(SqsQueueNameService sqsQueueNameService, NodeParams<PK, D, F> params, SqsClientType sqsClientType, SqsClientManager sqsClientManager, ClientId clientId) {
        super(params, (ClientType)sqsClientType);
        this.queueName = sqsQueueNameService.buildQueueName(params.getQueueUrl(), this.getFieldInfo().getTableName());
        this.params = params;
        this.sqsClientManager = sqsClientManager;
        this.clientId = clientId;
        this.queueUrlAndName = SingletonSupplier.of(this::getOrCreateQueueUrl);
        this.sqsOpFactory = new SqsOpFactory(this, sqsClientManager, clientId);
        this.owned = params.getQueueUrl() == null;
    }

    private QueueUrlAndName getOrCreateQueueUrl() {
        String queueUrl;
        if (this.owned) {
            queueUrl = this.createQueueAndGetUrl(this.queueName);
            this.sqsClientManager.updateAttr(this.clientId, queueUrl, QueueAttributeName.MessageRetentionPeriod, RETENTION_S);
            logger.warn("retention updated queueName=" + this.queueName);
        } else {
            queueUrl = this.params.getQueueUrl();
        }
        logger.warn("nodeName={}, queueUrl={}", (Object)this.getName(), (Object)queueUrl);
        return new QueueUrlAndName(queueUrl, this.queueName);
    }

    private String createQueueAndGetUrl(String queueName) {
        CreateQueueRequest createQueueRequest = new CreateQueueRequest(queueName);
        try {
            return this.sqsClientManager.getAmazonSqs(this.clientId).createQueue(createQueueRequest).getQueueUrl();
        }
        catch (RuntimeException e) {
            throw new RuntimeException("queueName=" + queueName + " queueNameLength=" + queueName.length(), e);
        }
    }

    @Override
    public Supplier<QueueUrlAndName> getQueueUrlAndName() {
        return this.queueUrlAndName;
    }

    @Override
    public boolean getAgeMonitoringStatusForMetricAlert() {
        return this.params.getAgeMonitoringStatus();
    }

    @Override
    public Duration getCustomMessageAgeThreshold() {
        return this.params.getCustomMessageAgeThreshold();
    }

    public boolean isOwned() {
        return this.owned;
    }

    public void ack(QueueMessageKey key, Config config) {
        this.sqsOpFactory.makeAckOp(key, config).call();
    }

    public void ackMulti(Collection<QueueMessageKey> keys, Config config) {
        this.sqsOpFactory.makeAckMultiOp(keys, config).call();
    }
}

