/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs.single;

import io.datarouter.aws.sqs.BaseSqsNode;
import io.datarouter.aws.sqs.SqsClientManager;
import io.datarouter.aws.sqs.SqsClientType;
import io.datarouter.aws.sqs.SqsQueueNameService;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.op.raw.QueueStorage;
import io.datarouter.storage.node.op.raw.read.QueueStorageReader;
import io.datarouter.storage.op.scan.queue.PeekMultiUntilEmptyQueueStorageScanner;
import io.datarouter.storage.op.scan.queue.PollUntilEmptyQueueStorageScanner;
import io.datarouter.storage.queue.BaseQueueMessage;
import io.datarouter.storage.queue.QueueMessage;
import io.datarouter.storage.queue.QueueMessageKey;
import java.util.Collection;
import java.util.List;

public class SqsNode<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>>
extends BaseSqsNode<PK, D, F>
implements QueueStorage.PhysicalQueueStorageNode<PK, D, F> {
    public SqsNode(SqsQueueNameService sqsQueueNameService, NodeParams<PK, D, F> params, SqsClientType sqsClientType, SqsClientManager sqsClientManager, ClientId clientId) {
        super(sqsQueueNameService, params, sqsClientType, sqsClientManager, clientId);
    }

    public QueueMessage<PK, D> peek(Config config) {
        Config limitedConfig = config.clone().setLimit(Integer.valueOf(1));
        return this.sqsOpFactory.makePeekMultiOp(limitedConfig).call().stream().findFirst().orElse(null);
    }

    public List<QueueMessage<PK, D>> peekMulti(Config config) {
        return this.sqsOpFactory.makePeekMultiOp(config).call();
    }

    public Scanner<QueueMessage<PK, D>> peekUntilEmpty(Config config) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (PeekMultiUntilEmptyQueueStorageScanner scanner = new PeekMultiUntilEmptyQueueStorageScanner((QueueStorageReader)this, config);){
            return scanner.concat(Scanner::of);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void put(D databean, Config config) {
        this.sqsOpFactory.makePutOp(databean, config).call();
    }

    public void putMulti(Collection<D> databeans, Config config) {
        this.sqsOpFactory.makePutMultiOp(databeans, config).call();
    }

    public D poll(Config config) {
        QueueMessage<PK, D> message = this.peek(config);
        if (message == null) {
            return null;
        }
        this.ack(message.getKey(), config);
        return (D)message.getDatabean();
    }

    public List<D> pollMulti(Config config) {
        List<QueueMessage<PK, D>> messages = this.peekMulti(config);
        Scanner.of(messages).map(BaseQueueMessage::getKey).flush(keys -> this.ackMulti((Collection<QueueMessageKey>)keys, config));
        return Scanner.of(messages).map(QueueMessage::getDatabean).list();
    }

    public Scanner<D> pollUntilEmpty(Config config) {
        return new PollUntilEmptyQueueStorageScanner((QueueStorage)this, config);
    }
}

