/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs.service;

import io.datarouter.aws.sqs.SqsClientType;
import io.datarouter.aws.sqs.service.SqsQueueRegistryService;
import io.datarouter.email.html.J2HtmlEmailTable;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.DatarouterClients;
import io.datarouter.web.config.DatarouterWebPaths;
import io.datarouter.web.digest.DailyDigest;
import io.datarouter.web.digest.DailyDigestGrouping;
import io.datarouter.web.digest.DailyDigestService;
import io.datarouter.web.html.j2html.J2HtmlTable;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.H3Tag;
import j2html.tags.specialized.TableTag;
import java.time.ZoneId;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class SqsQueuesDailyDigest
implements DailyDigest {
    @Inject
    private DatarouterClients datarouterClients;
    @Inject
    private DatarouterWebPaths paths;
    @Inject
    private SqsQueueRegistryService queueRegistryService;
    @Inject
    private DailyDigestService digestService;

    public String getTitle() {
        return "Sqs Queues";
    }

    public DailyDigestGrouping getGrouping() {
        return DailyDigestGrouping.LOW;
    }

    public Optional<DivTag> getPageContent(ZoneId zoneId) {
        return this.buildContent(ContentType.PAGE);
    }

    public Optional<DivTag> getEmailContent(ZoneId zoneId) {
        return this.buildContent(ContentType.EMAIL);
    }

    public DailyDigest.DailyDigestType getType() {
        return DailyDigest.DailyDigestType.ACTIONABLE;
    }

    private Optional<DivTag> buildContent(ContentType contentType) {
        ClientId clientId = Scanner.of((Iterable)this.datarouterClients.getClientIds()).include(client -> this.datarouterClients.getClientTypeInstance(client) instanceof SqsClientType).findFirst().orElse(null);
        if (clientId == null) {
            return Optional.empty();
        }
        List<String> unreferencedQueues = this.queueRegistryService.getSqsQueuesForClient(clientId).unreferencedQueues();
        if (unreferencedQueues.isEmpty()) {
            return Optional.empty();
        }
        TableTag unreferencedQueuesTable = new TableTag();
        if (contentType == ContentType.PAGE) {
            unreferencedQueuesTable = new J2HtmlTable().withClasses(new String[]{"sortable table table-sm table-striped my-4 border"}).withHtmlColumn((DomContent)TagCreator.th((String)"Queue Name"), TagCreator::td).build(unreferencedQueues);
        } else if (contentType == ContentType.EMAIL) {
            unreferencedQueuesTable = new J2HtmlEmailTable().withColumn("Queue Name", row -> row).build(unreferencedQueues);
        }
        H3Tag header = this.digestService.makeHeader("Unreferenced Sqs Queues", this.paths.datarouter.client.inspectClient, "?clientName=sqs");
        return Optional.of(TagCreator.div((DomContent[])new DomContent[]{header, unreferencedQueuesTable}));
    }

    private static enum ContentType {
        PAGE,
        EMAIL;

    }
}

