/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs.op;

import io.datarouter.aws.sqs.BaseSqsNode;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.StringDatabeanCodec;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.serialize.fieldcache.PhysicalDatabeanFieldInfo;
import java.util.concurrent.Callable;
import java.util.function.Supplier;

public abstract class SqsOp<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, V>
implements Callable<V> {
    protected final Config config;
    protected final String queueUrl;
    protected final Supplier<D> databeanSupplier;
    protected final F fielder;
    protected final StringDatabeanCodec codec;
    protected final PhysicalDatabeanFieldInfo<PK, D, F> fieldInfo;

    public SqsOp(Config config, BaseSqsNode<PK, D, F> sqsNode) {
        this.config = config;
        this.queueUrl = sqsNode.getQueueUrlAndName().get().queueUrl();
        this.databeanSupplier = sqsNode.getFieldInfo().getDatabeanSupplier();
        this.fielder = sqsNode.getFieldInfo().getSampleFielder();
        this.codec = this.fielder.getStringDatabeanCodec();
        this.fieldInfo = sqsNode.getFieldInfo();
    }

    @Override
    public V call() {
        return this.run();
    }

    protected abstract V run();
}

