/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs.group;

import io.datarouter.aws.sqs.BaseSqsNode;
import io.datarouter.aws.sqs.SqsClientManager;
import io.datarouter.aws.sqs.SqsClientType;
import io.datarouter.aws.sqs.SqsQueueNameService;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.op.raw.GroupQueueStorage;
import io.datarouter.storage.node.op.raw.read.GroupQueueStorageReader;
import io.datarouter.storage.op.scan.queue.group.PeekMultiGroupUntilEmptyQueueStorageScanner;
import io.datarouter.storage.queue.BaseQueueMessage;
import io.datarouter.storage.queue.GroupQueueMessage;
import io.datarouter.storage.queue.QueueMessageKey;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class SqsGroupNode<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>>
extends BaseSqsNode<PK, D, F>
implements GroupQueueStorage.PhysicalGroupQueueStorageNode<PK, D, F> {
    public SqsGroupNode(SqsQueueNameService sqsQueueNameService, NodeParams<PK, D, F> params, SqsClientType sqsClientType, SqsClientManager sqsClientManager, ClientId clientId) {
        super(sqsQueueNameService, params, sqsClientType, sqsClientManager, clientId);
    }

    public void put(D databean, Config config) {
        this.sqsOpFactory.makeGroupPutMultiOp(Collections.singleton(databean), config).call();
    }

    public void putMulti(Collection<D> databeans, Config config) {
        this.sqsOpFactory.makeGroupPutMultiOp(databeans, config).call();
    }

    public GroupQueueMessage<PK, D> peek(Config config) {
        Config limitedConfig = config.clone().setLimit(Integer.valueOf(1));
        return this.peekMulti(limitedConfig).stream().findFirst().orElse(null);
    }

    public List<GroupQueueMessage<PK, D>> peekMulti(Config config) {
        return this.sqsOpFactory.makeGroupPeekMultiOp(config).call();
    }

    public Scanner<GroupQueueMessage<PK, D>> peekUntilEmpty(Config config) {
        return new PeekMultiGroupUntilEmptyQueueStorageScanner((GroupQueueStorageReader)this, config).concat(Scanner::of);
    }

    public List<D> pollMulti(Config config) {
        List<GroupQueueMessage<PK, D>> results = this.peekMulti(config);
        Scanner.of(results).map(BaseQueueMessage::getKey).flush(keys -> this.ackMulti((Collection<QueueMessageKey>)keys, config));
        return Scanner.of(results).map(GroupQueueMessage::getDatabeans).concat(Scanner::of).list();
    }
}

