/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs.job;

import com.amazonaws.services.sqs.model.QueueAttributeName;
import io.datarouter.aws.sqs.BaseSqsNode;
import io.datarouter.aws.sqs.SqsClientManager;
import io.datarouter.aws.sqs.SqsClientType;
import io.datarouter.instrumentation.task.TaskTracker;
import io.datarouter.job.BaseJob;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientInitializationTracker;
import io.datarouter.storage.client.DatarouterClients;
import io.datarouter.storage.node.DatarouterNodes;
import io.datarouter.storage.node.NodeTool;
import io.datarouter.storage.util.DatarouterQueueMetrics;
import io.datarouter.util.tuple.Pair;
import io.datarouter.util.tuple.Twin;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqsMonitoringJob
extends BaseJob {
    private static final Logger logger = LoggerFactory.getLogger(SqsMonitoringJob.class);
    @Inject
    private DatarouterClients datarouterClients;
    @Inject
    private DatarouterNodes datarouterNodes;
    @Inject
    private SqsClientManager sqsClientManager;
    @Inject
    private ClientInitializationTracker clientInitializationTracker;
    @Inject
    private DatarouterQueueMetrics metrics;

    public void run(TaskTracker tracker) {
        this.clientInitializationTracker.getInitializedClients().stream().filter(clientId -> this.datarouterClients.getClientTypeInstance(clientId) instanceof SqsClientType).forEach(clientId -> {
            Collection nodes = this.datarouterNodes.getPhysicalNodesForClient(clientId.getName());
            List<Twin> queueUrlAndNames = nodes.stream().map(NodeTool::extractSinglePhysicalNode).map(physicalNode -> (BaseSqsNode)((Object)((Object)physicalNode))).peek($ -> {
                TaskTracker taskTracker2 = tracker.increment();
            }).map(BaseSqsNode::getQueueUrlAndName).map(Supplier::get).collect(Collectors.toList());
            this.saveUnackedMessageAgeMetricForQueues((ClientId)clientId, queueUrlAndNames.stream().map(Pair::getRight).collect(Collectors.toList()));
            queueUrlAndNames.forEach(queueUrlAndName -> {
                try {
                    this.getQueueLengthAndSaveAsMetric((Twin<String>)queueUrlAndName, (ClientId)clientId);
                }
                catch (RuntimeException e) {
                    logger.warn("failed to get attribute for queue=" + (String)queueUrlAndName.getRight(), (Throwable)e);
                }
            });
        });
    }

    private void saveUnackedMessageAgeMetricForQueues(ClientId clientId, List<String> queueNames) {
        this.sqsClientManager.getApproximateAgeOfOldestUnackedMessageSecondsGroup(clientId, queueNames).entrySet().forEach(entry -> this.metrics.saveOldestAckMessageAge((String)entry.getKey(), ((Long)entry.getValue()).longValue(), "sqs"));
    }

    private void getQueueLengthAndSaveAsMetric(Twin<String> queueUrlAndName, ClientId clientId) {
        String queueLengthString = this.sqsClientManager.getQueueAttribute(clientId, (String)queueUrlAndName.getLeft(), QueueAttributeName.ApproximateNumberOfMessages);
        long queueLength = Long.parseLong(queueLengthString);
        this.metrics.saveQueueLength((String)queueUrlAndName.getRight(), queueLength, "sqs");
    }
}

