/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs.blob.op;

import com.amazonaws.AbortedException;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.MessageAttributeValue;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import io.datarouter.aws.sqs.BaseSqsNode;
import io.datarouter.aws.sqs.SqsClientManager;
import io.datarouter.aws.sqs.op.SqsBlobOp;
import io.datarouter.bytes.codec.stringcodec.StringCodec;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.queue.BlobQueueMessageDto;
import io.datarouter.util.concurrent.UncheckedInterruptedException;
import java.time.Duration;
import java.util.List;
import java.util.Map;

public class SqsBlobPeekOp
extends SqsBlobOp<BlobQueueMessageDto> {
    public SqsBlobPeekOp(Config config, SqsClientManager sqsClientManager, ClientId clientId, String queueUrl) {
        super(sqsClientManager, clientId, config, queueUrl);
    }

    @Override
    protected BlobQueueMessageDto run() {
        ReceiveMessageResult result;
        ReceiveMessageRequest request = this.makeRequest();
        try {
            result = this.sqsClientManager.getAmazonSqs(this.clientId).receiveMessage(request);
        }
        catch (AbortedException e) {
            throw new UncheckedInterruptedException("", (Exception)((Object)e));
        }
        List messages = result.getMessages();
        if (messages.isEmpty()) {
            return null;
        }
        Message message = (Message)messages.get(0);
        byte[] data = StringCodec.UTF_8.encode(message.getBody());
        byte[] receiptHandle = StringCodec.UTF_8.encode(message.getReceiptHandle());
        Map attributes = Scanner.of(message.getMessageAttributes().entrySet()).toMap(Map.Entry::getKey, entry -> ((MessageAttributeValue)entry.getValue()).getStringValue());
        return new BlobQueueMessageDto(receiptHandle, data, attributes);
    }

    private ReceiveMessageRequest makeRequest() {
        ReceiveMessageRequest request = new ReceiveMessageRequest(this.queueUrl);
        Duration configTimeout = this.config.findTimeout().orElse(Duration.ofMillis(Long.MAX_VALUE));
        long waitTimeMs = Math.min(configTimeout.toMillis(), 20000L);
        request.setWaitTimeSeconds(Integer.valueOf((int)Duration.ofMillis(waitTimeMs).getSeconds()));
        long visibilityTimeoutMs = this.config.getVisibilityTimeoutMsOrUse(BaseSqsNode.DEFAULT_VISIBILITY_TIMEOUT_MS);
        request.setVisibilityTimeout(Integer.valueOf((int)Duration.ofMillis(visibilityTimeoutMs).getSeconds()));
        request.setMaxNumberOfMessages(Integer.valueOf(1));
        request.withMessageAttributeNames(new String[]{"ALL"});
        return request;
    }
}

