/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs.web;

import com.amazonaws.services.sqs.model.QueueAttributeName;
import io.datarouter.aws.sqs.SqsClientManager;
import io.datarouter.aws.sqs.SqsClientType;
import io.datarouter.aws.sqs.config.DatarouterSqsPaths;
import io.datarouter.aws.sqs.service.SqsQueueRegistryService;
import io.datarouter.pathnode.PathNode;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientOptions;
import io.datarouter.util.number.NumberFormatter;
import io.datarouter.util.number.NumberTool;
import io.datarouter.util.tuple.Pair;
import io.datarouter.util.tuple.Twin;
import io.datarouter.web.browse.DatarouterClientWebInspector;
import io.datarouter.web.browse.dto.DatarouterWebRequestParamsFactory;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.handler.mav.imp.MessageMav;
import io.datarouter.web.handler.params.Params;
import io.datarouter.web.html.j2html.J2HtmlLegendTable;
import io.datarouter.web.html.j2html.J2HtmlTable;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4PageFactory;
import io.datarouter.web.requirejs.DatarouterWebRequireJsV2;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import j2html.tags.specialized.ATag;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.TableTag;
import j2html.tags.specialized.ThTag;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.client.utils.URIBuilder;

public class SqsWebInspector
implements DatarouterClientWebInspector {
    @Inject
    private DatarouterWebRequestParamsFactory paramsFactory;
    @Inject
    private SqsClientManager sqsClientManager;
    @Inject
    private Bootstrap4PageFactory pageFactory;
    @Inject
    private ClientOptions clientOptions;
    @Inject
    private DatarouterSqsPaths paths;
    @Inject
    private SqsQueueRegistryService queueRegistryService;

    public Mav inspectClient(Params params, HttpServletRequest request) {
        DatarouterWebRequestParamsFactory datarouterWebRequestParamsFactory = this.paramsFactory;
        datarouterWebRequestParamsFactory.getClass();
        DatarouterWebRequestParamsFactory.DatarouterWebRequestParams clientParams = new DatarouterWebRequestParamsFactory.DatarouterWebRequestParams(datarouterWebRequestParamsFactory, params, SqsClientType.class);
        ClientId clientId = clientParams.getClientId();
        if (clientId == null) {
            return new MessageMav("Client not found");
        }
        String clientName = clientId.getName();
        Map allClientOptions = this.clientOptions.getAllClientOptions(clientName);
        DivTag content = (DivTag)TagCreator.div((DomContent[])new DomContent[]{this.buildClientPageHeader(clientName), this.buildClientOptionsTable(allClientOptions), this.buildQueueNodeTable(clientId, request), this.buildReferenceTable()}).withClass("container my-4");
        return this.pageFactory.startBuilder(request).withTitle("Datarouter Client - SQS").withRequires(new String[]{DatarouterWebRequireJsV2.SORTTABLE}).withContent((DomContent)content).buildMav();
    }

    private ContainerTag<?> buildQueueNodeTable(ClientId clientId, HttpServletRequest request) {
        Pair<List<Twin<String>>, List<String>> queueRegistry = this.queueRegistryService.getSqsQueuesForClient(clientId);
        List knownQueueUrlByName = (List)queueRegistry.getLeft();
        List queueStatsRows = Scanner.of((Iterable)knownQueueUrlByName).map(queueUrlAndName -> {
            String queueName = (String)queueUrlAndName.getRight();
            String queueUrl = (String)queueUrlAndName.getLeft();
            Map<String, String> attributesMap = this.sqsClientManager.getAllQueueAttributes(clientId, queueUrl);
            return new SqsWebInspectorDto(queueName, attributesMap.get(QueueAttributeName.ApproximateNumberOfMessages.name()), attributesMap.get(QueueAttributeName.ApproximateNumberOfMessagesDelayed.name()), attributesMap.get(QueueAttributeName.ApproximateNumberOfMessagesNotVisible.name()));
        }).sort(Comparator.comparing(dto -> dto.queueName)).list();
        TableTag table = new J2HtmlTable().withClasses(new String[]{"sortable table table-sm table-striped my-4 border"}).withHtmlColumn((DomContent)TagCreator.th((String)"Queue Name").withClass("col-xs-5"), row -> TagCreator.td((String)row.queueName)).withHtmlColumn((DomContent)TagCreator.th((String)"Available For Retrieval").withClass("col-xs-3"), row -> TagCreator.td((String)row.messagesAvailableForRetrieval)).withHtmlColumn((DomContent)TagCreator.th((String)"Delayed").withClass("col-xs-1"), row -> TagCreator.td((String)row.messagesDelayed)).withHtmlColumn((DomContent)TagCreator.th((String)"InFlight").withClass("col-xs-1"), row -> TagCreator.td((String)row.messagesInFlight)).withHtmlColumn((DomContent)TagCreator.th((String)"Total").withClass("col-xs-1"), row -> TagCreator.td((String)row.getTotalMessagesAvailable())).withHtmlColumn((DomContent)TagCreator.th((String)"").attr("width", (Object)"80"), row -> {
            String href = this.buildActionPath(request, clientId, row.queueName, SqsQueueAction.PURGE);
            ATag purgeIcon = (ATag)((ATag)((ATag)TagCreator.a((DomContent[])new DomContent[]{TagCreator.i().withClass("fas fa-skull-crossbones fa-lg")}).withHref(href)).attr("data-toggle", (Object)"tooltip")).attr("title", (Object)("Purge queue " + row.queueName));
            return TagCreator.td((DomContent[])new DomContent[]{purgeIcon}).withStyle("text-align:center");
        }).build((Collection)queueStatsRows);
        List unreferencedQueues = (List)queueRegistry.getRight();
        if (unreferencedQueues.isEmpty()) {
            return (ContainerTag)((DivTag)TagCreator.div((DomContent[])new DomContent[]{TagCreator.h4((String)"Queues"), table}).withClass("container-fluid my-4")).withStyle("padding-left: 0px");
        }
        TableTag unreferencedQueuesTable = new J2HtmlTable().withClasses(new String[]{"sortable table table-sm table-striped my-4 border"}).withHtmlColumn((DomContent)TagCreator.th((String)"Queue Name"), TagCreator::td).withHtmlColumn((DomContent)((ThTag)TagCreator.th((DomContent[])new DomContent[]{TagCreator.a((String)"Delete All").withHref(this.buildActionPath(request, clientId, "", SqsQueueAction.DELETE_ALL))}).withStyle("text-align:center")).attr("width", (Object)"80"), row -> {
            String href = this.buildActionPath(request, clientId, (String)row, SqsQueueAction.DELETE);
            ATag trashIcon = (ATag)((ATag)((ATag)TagCreator.a((DomContent[])new DomContent[]{TagCreator.i().withClass("fas fa-trash fa-lg")}).withHref(href)).attr("data-toggle", (Object)"tooltip")).attr("title", (Object)("Delete queue " + row));
            return TagCreator.td((DomContent[])new DomContent[]{trashIcon}).withStyle("text-align:center");
        }).build((Collection)unreferencedQueues);
        return (ContainerTag)((DivTag)TagCreator.div((DomContent[])new DomContent[]{TagCreator.h4((String)"Queues"), table, TagCreator.h4((String)"Unreferenced Queues"), unreferencedQueuesTable}).withClass("container-fluid my-4")).withStyle("padding-left: 0px");
    }

    private ContainerTag<?> buildReferenceTable() {
        return (ContainerTag)((ContainerTag)new J2HtmlLegendTable().withHeader("Legend").withClass("sortable table table-sm my-4 border").withEntry("Messages Available For Retrieval", "The approximate number of messages available for retrieval from the queue").withEntry("Messages Delayed", "The approximate number of messages in the queue that are delayed and not available for reading immediately. This can happen when the queue is configured as a delay queue or when a message has been sent with a delay parameter.").withEntry("Messages In Flight", "Messages are considered to be in flight if they have been sent to a client but have not yet been deleted or have not yet reached the end of their visibility window.").withEntry("Total Messages", "A total of Available + InFlight messages").withEntry("Unreferenced Queue", "Queue which exists but the application is not aware of, usually a result of the queue being renamed, or code refactored").build().withClass("container-fluid my-4")).withStyle("padding-left: 0px");
    }

    private String buildActionPath(HttpServletRequest request, ClientId clientId, String queueName, SqsQueueAction action) {
        PathNode path;
        String referer = String.valueOf(request.getRequestURI()) + "?" + request.getQueryString();
        URIBuilder uriBuilder = new URIBuilder().addParameter("clientName", clientId.getName()).addParameter("referer", referer);
        if (action == SqsQueueAction.DELETE) {
            path = this.paths.datarouter.sqs.deleteQueue;
            uriBuilder.addParameter("queueName", queueName);
        } else if (action == SqsQueueAction.PURGE) {
            path = this.paths.datarouter.sqs.purgeQueue;
            uriBuilder.addParameter("queueName", queueName);
        } else if (action == SqsQueueAction.DELETE_ALL) {
            path = this.paths.datarouter.sqs.deleteAllUnreferencedQueues;
        } else {
            return null;
        }
        return uriBuilder.setPath(String.valueOf(request.getContextPath()) + path.toSlashedString()).toString();
    }

    private static enum SqsQueueAction {
        DELETE,
        DELETE_ALL,
        PURGE;

    }

    private static class SqsWebInspectorDto {
        private final String queueName;
        private final String messagesAvailableForRetrieval;
        private final String messagesDelayed;
        private final String messagesInFlight;

        private SqsWebInspectorDto(String queueName, String messagesAvailableForRetrieval, String messagesDelayed, String messagesInFlight) {
            this.queueName = queueName;
            this.messagesAvailableForRetrieval = messagesAvailableForRetrieval;
            this.messagesDelayed = messagesDelayed;
            this.messagesInFlight = messagesInFlight;
        }

        private String getTotalMessagesAvailable() {
            long available = NumberTool.getLongNullSafe((String)this.messagesAvailableForRetrieval, (Long)0L);
            long inFlight = NumberTool.getLongNullSafe((String)this.messagesInFlight, (Long)0L);
            long total = available + inFlight;
            return NumberFormatter.addCommas((Number)total);
        }
    }
}

