/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs.web.handler;

import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.GetQueueUrlResult;
import com.amazonaws.services.sqs.model.PurgeQueueRequest;
import io.datarouter.aws.sqs.SqsClientManager;
import io.datarouter.aws.sqs.service.SqsQueueRegistryService;
import io.datarouter.instrumentation.changelog.ChangelogRecorder;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.DatarouterClients;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.handler.types.Param;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4PageFactory;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.ATag;
import j2html.tags.specialized.DivTag;
import java.util.List;
import javax.inject.Inject;

public class SqsUpdateQueueHandler
extends BaseHandler {
    public static final String PARAM_clientName = "clientName";
    public static final String PARAM_queueName = "queueName";
    public static final String PARAM_referer = "referer";
    @Inject
    private ChangelogRecorder changelogRecorder;
    @Inject
    private SqsClientManager sqsClientManager;
    @Inject
    private DatarouterClients datarouterClients;
    @Inject
    private Bootstrap4PageFactory pageFactory;
    @Inject
    private SqsQueueRegistryService queueRegistryService;

    @BaseHandler.Handler
    private Mav deleteQueue(@Param(value="clientName") String clientName, @Param(value="queueName") String queueName, @Param(value="referer") String referer) {
        ClientId clientId = this.datarouterClients.getClientId(clientName);
        AmazonSQS sqs = this.sqsClientManager.getAmazonSqs(clientId);
        GetQueueUrlResult queueUrlResult = sqs.getQueueUrl(queueName);
        sqs.deleteQueue(queueUrlResult.getQueueUrl());
        String message = "Deleted unreferenced SQS queue: " + queueName;
        ChangelogRecorder.DatarouterChangelogDto dto = new ChangelogRecorder.DatarouterChangelogDtoBuilder("Sqs", queueName, "deleteQueue", this.getSessionInfo().getRequiredSession().getUsername()).build();
        this.changelogRecorder.record(dto);
        return this.buildPage(referer, message);
    }

    @BaseHandler.Handler
    private Mav deleteAllUnreferencedQueues(@Param(value="clientName") String clientName, @Param(value="referer") String referer) {
        ClientId clientId = this.datarouterClients.getClientId(clientName);
        List unreferencedQueueNames = (List)this.queueRegistryService.getSqsQueuesForClient(clientId).getRight();
        AmazonSQS sqs = this.sqsClientManager.getAmazonSqs(clientId);
        Scanner.of((Iterable)unreferencedQueueNames).map(arg_0 -> ((AmazonSQS)sqs).getQueueUrl(arg_0)).map(GetQueueUrlResult::getQueueUrl).forEach(arg_0 -> ((AmazonSQS)sqs).deleteQueue(arg_0));
        String message = "Deleted all unreferenced SQS queues";
        ChangelogRecorder.DatarouterChangelogDto dto = new ChangelogRecorder.DatarouterChangelogDtoBuilder("Sqs", "", "deleteAllUnreferencedQueues", this.getSessionInfo().getRequiredSession().getUsername()).build();
        this.changelogRecorder.record(dto);
        return this.buildPage(referer, message);
    }

    @BaseHandler.Handler
    private Mav purgeQueue(@Param(value="clientName") String clientName, @Param(value="queueName") String queueName, @Param(value="referer") String referer) {
        ClientId clientId = this.datarouterClients.getClientId(clientName);
        AmazonSQS sqs = this.sqsClientManager.getAmazonSqs(clientId);
        GetQueueUrlResult queueUrlResult = sqs.getQueueUrl(queueName);
        sqs.purgeQueue(new PurgeQueueRequest(queueUrlResult.getQueueUrl()));
        String message = "Purged SQS queue: " + queueName;
        ChangelogRecorder.DatarouterChangelogDto dto = new ChangelogRecorder.DatarouterChangelogDtoBuilder("Sqs", queueName, "purgeQueue", this.getSessionInfo().getRequiredSession().getUsername()).build();
        this.changelogRecorder.record(dto);
        return this.buildPage(referer, message);
    }

    private Mav buildPage(String href, String message) {
        DivTag backButton = TagCreator.div((DomContent[])new DomContent[]{((ATag)((ATag)TagCreator.a((DomContent[])new DomContent[]{TagCreator.i().withClass("fas fa-angle-left")}).withText("Go back to client details")).withHref(href)).withClass("btn btn-primary")});
        DivTag content = (DivTag)TagCreator.div((DomContent[])new DomContent[]{backButton, TagCreator.div((String)message).withClass("my-4")}).withClass("container my-4");
        return this.pageFactory.startBuilder(this.request).withContent((DomContent)content).withTitle("Update Sqs Queue").buildMav();
    }
}

