/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.aws.sqs;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSClient;
import com.amazonaws.services.sqs.AmazonSQSClientBuilder;
import io.datarouter.aws.sqs.SqsOptions;
import io.datarouter.storage.client.ClientId;
import io.datarouter.web.config.AwsSupport;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class AmazonSqsHolder {
    private final Map<ClientId, AmazonSQS> amazonSqsByClient = new ConcurrentHashMap<ClientId, AmazonSQS>();
    @Inject
    private SqsOptions sqsOptions;
    @Inject
    private AwsSupport awsSupport;

    public void registerClient(ClientId clientId) {
        if (this.amazonSqsByClient.containsKey(clientId)) {
            throw new RuntimeException(clientId + " already registered an sqs client");
        }
        ClientConfiguration conf = new ClientConfiguration().withMaxConnections(200);
        BasicAWSCredentials credentials = new BasicAWSCredentials(this.sqsOptions.getAccessKey(clientId.getName()), this.sqsOptions.getSecretKey(clientId.getName()));
        AWSStaticCredentialsProvider credentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)credentials);
        AmazonSQS amazonSqs = (AmazonSQS)((AmazonSQSClientBuilder)((AmazonSQSClientBuilder)((AmazonSQSClientBuilder)AmazonSQSClient.builder().withClientConfiguration(conf)).withCredentials((AWSCredentialsProvider)credentialsProvider)).withRegion(this.sqsOptions.getRegion(clientId.getName()))).build();
        this.awsSupport.registerConnectionManager("sqs " + clientId.getName(), (Object)amazonSqs);
        this.amazonSqsByClient.put(clientId, amazonSqs);
    }

    public AmazonSQS get(ClientId clientId) {
        return this.amazonSqsByClient.get(clientId);
    }
}

