/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.autoconfig.web;

import io.datarouter.autoconfig.config.DatarouterAutoConfigExecutors;
import io.datarouter.autoconfig.service.AutoConfigService;
import io.datarouter.scanner.ParallelScannerContext;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.servertype.ServerTypeDetector;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.encoder.RawStringEncoder;
import io.datarouter.web.handler.types.Param;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class DatarouterAutoConfigHandler
extends BaseHandler {
    public static final String P_name = "name";
    @Inject
    private AutoConfigService autoConfigService;
    @Inject
    private ServerTypeDetector serverTypeDetector;
    @Inject
    private DatarouterAutoConfigExecutors.AutoConfigExecutor executor;

    @BaseHandler.Handler(defaultHandler=true, encoder=RawStringEncoder.class)
    private String home() {
        this.serverTypeDetector.assertNotProductionServer();
        return (String)Scanner.of(this.autoConfigService.getAutoConfigByName().entrySet()).map(Map.Entry::getValue).parallel(new ParallelScannerContext((ExecutorService)((Object)this.executor), 8, true)).map(callable -> {
            try {
                return (String)callable.call();
            }
            catch (Exception e) {
                return null;
            }
        }).collect(Collectors.joining("\n"));
    }

    @BaseHandler.Handler(encoder=RawStringEncoder.class)
    public String runForName(@Param(value="name") String name) throws Exception {
        this.serverTypeDetector.assertNotProductionServer();
        Callable<String> callable = this.autoConfigService.getAutoConfigByName().get(name);
        return callable.call();
    }
}

