/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.autoconfig.service;

import io.datarouter.autoconfig.service.AutoConfigRegistry;
import io.datarouter.inject.DatarouterInjector;
import io.datarouter.scanner.Scanner;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class AutoConfigService {
    private final Map<String, Callable<String>> autoConfigByName = new HashMap<String, Callable<String>>();

    @Inject
    public AutoConfigService(AutoConfigRegistry autoConfigRegistry, DatarouterInjector injector) {
        Scanner.of(autoConfigRegistry.autoConfigs).map(arg_0 -> ((DatarouterInjector)injector).getInstance(arg_0)).forEach(config -> {
            Callable<String> callable = this.autoConfigByName.put(config.getName(), (Callable<String>)config);
        });
        Scanner.of(autoConfigRegistry.autoConfigGroups).map(arg_0 -> ((DatarouterInjector)injector).getInstance(arg_0)).forEach(config -> {
            Callable<String> callable = this.autoConfigByName.put(config.getName(), (Callable<String>)config);
        });
    }

    public Map<String, Callable<String>> getAutoConfigByName() {
        return this.autoConfigByName;
    }
}

