/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.autoconfig.web;

import io.datarouter.autoconfig.config.DatarouterAutoConfigPaths;
import io.datarouter.autoconfig.service.AutoConfigRegistry;
import io.datarouter.inject.DatarouterInjector;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.servertype.ServerTypeDetector;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.encoder.RawStringEncoder;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.handler.types.Param;
import io.datarouter.web.html.j2html.J2HtmlTable;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4PageFactory;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.inject.Inject;

public class ViewAutoConfigsHandler
extends BaseHandler {
    private static final String P_name = "name";
    private final Bootstrap4PageFactory pageFactory;
    private final ServerTypeDetector serverTypeDetector;
    private final DatarouterInjector injector;
    private final DatarouterAutoConfigPaths paths;
    private final Map<String, Class<? extends Callable<String>>> map;

    @Inject
    public ViewAutoConfigsHandler(Bootstrap4PageFactory pageFactory, ServerTypeDetector serverTypeDetector, AutoConfigRegistry autoConfigRegistry, DatarouterInjector injector, DatarouterAutoConfigPaths paths) {
        this.pageFactory = pageFactory;
        this.serverTypeDetector = serverTypeDetector;
        this.injector = injector;
        this.paths = paths;
        this.map = new HashMap<String, Class<? extends Callable<String>>>();
        Scanner.of(autoConfigRegistry.autoConfigs).map(arg_0 -> ((DatarouterInjector)injector).getInstance(arg_0)).forEach(config -> {
            Class<?> clazz = this.map.put(config.getName(), config.getClass());
        });
        Scanner.of(autoConfigRegistry.autoConfigGroups).map(arg_0 -> ((DatarouterInjector)injector).getInstance(arg_0)).forEach(config -> {
            Class<?> clazz = this.map.put(config.getName(), config.getClass());
        });
    }

    @BaseHandler.Handler
    public Mav viewAutoConfigs() {
        if (this.serverTypeDetector.mightBeProduction()) {
            return this.pageFactory.message(this.request, "This is not supported on production");
        }
        ContainerTag runAllButton = (ContainerTag)((ContainerTag)((ContainerTag)TagCreator.a((String)"Run All").withClass("btn btn-primary")).withType("button")).withHref(String.valueOf(this.request.getServletContext().getContextPath()) + this.paths.datarouter.autoConfig.toSlashedString());
        ContainerTag header = TagCreator.div((DomContent[])new DomContent[]{TagCreator.h2((String)"AutoConfigs"), runAllButton});
        ContainerTag content = (ContainerTag)TagCreator.div((DomContent[])new DomContent[]{header, this.makeContent(this.map)}).withClass("container-fluid");
        return this.pageFactory.startBuilder(this.request).withTitle("Registered AutoConfig Classes").withContent(content).buildMav();
    }

    @BaseHandler.Handler(encoder=RawStringEncoder.class)
    public String runForName(@Param(value="name") String name) throws Exception {
        if (this.serverTypeDetector.mightBeProduction()) {
            return "This is not supported on production";
        }
        Class<? extends Callable<String>> callableClass = this.map.get(name);
        return (String)((Callable)this.injector.getInstance(callableClass)).call();
    }

    private ContainerTag makeContent(Map<String, Class<? extends Callable<String>>> map) {
        ContainerTag table = new J2HtmlTable().withClasses(new String[]{"table table-sm table-striped my-4 border"}).withColumn("AutoConfig", row -> row.getKey()).withHtmlColumn("Run", row -> TagCreator.td((DomContent[])new DomContent[]{((ContainerTag)((ContainerTag)TagCreator.a((String)"Trigger").withClass("btn btn-primary")).withType("button")).withHref(String.valueOf(this.request.getServletContext().getContextPath()) + this.paths.datarouter.autoConfigs.runForName.toSlashedString() + "?" + P_name + "=" + (String)row.getKey())})).withCaption("Total: " + map.size()).build(map.entrySet());
        return (ContainerTag)TagCreator.div((DomContent[])new DomContent[]{table}).withClass("container my-4");
    }
}

