/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.autoconfig.config;

import io.datarouter.autoconfig.config.DatarouterAutoConfigPaths;
import io.datarouter.autoconfig.config.DatarouterAutoConfigRouteSet;
import io.datarouter.autoconfig.service.AutoConfig;
import io.datarouter.autoconfig.service.AutoConfigGroup;
import io.datarouter.autoconfig.service.AutoConfigRegistry;
import io.datarouter.web.config.BaseWebPlugin;
import io.datarouter.web.navigation.DatarouterNavBarCategory;
import io.datarouter.web.navigation.NavBarCategory;
import java.util.HashSet;
import java.util.Set;

public class DatarouterAutoConfigPlugin
extends BaseWebPlugin {
    private static final DatarouterAutoConfigPaths PATHS = new DatarouterAutoConfigPaths();
    private final Set<Class<? extends AutoConfig>> autoConfigs;
    private final Set<Class<? extends AutoConfigGroup>> autoConfigGroups;

    private DatarouterAutoConfigPlugin(Set<Class<? extends AutoConfig>> autoConfigs, Set<Class<? extends AutoConfigGroup>> autoConfigGroups) {
        this.autoConfigs = autoConfigs;
        this.autoConfigGroups = autoConfigGroups;
        this.addRouteSet(DatarouterAutoConfigRouteSet.class);
        this.addDatarouterNavBarItem((NavBarCategory)DatarouterNavBarCategory.INFO, DatarouterAutoConfigPlugin.PATHS.datarouter.autoConfigs.viewAutoConfigs, "AutoConfigs");
        this.addDatarouterGithubDocLink("datarouter-auto-config");
    }

    public String getName() {
        return "DatarouterAutoConfig";
    }

    public void configure() {
        this.bind(AutoConfigRegistry.class).toInstance((Object)new AutoConfigRegistry(this.autoConfigs, this.autoConfigGroups));
    }

    public static class DatarouterAutoConfigPluginBuilder {
        private Set<Class<? extends AutoConfig>> autoConfigs = new HashSet<Class<? extends AutoConfig>>();
        private Set<Class<? extends AutoConfigGroup>> autoConfigGroups = new HashSet<Class<? extends AutoConfigGroup>>();

        public DatarouterAutoConfigPluginBuilder addAutoConfig(Class<? extends AutoConfig> autoConfig) {
            this.autoConfigs.add(autoConfig);
            return this;
        }

        public DatarouterAutoConfigPluginBuilder addAutoConfigGroup(Class<? extends AutoConfigGroup> autoConfigGroup) {
            this.autoConfigGroups.add(autoConfigGroup);
            return this;
        }

        public DatarouterAutoConfigPlugin build() {
            return new DatarouterAutoConfigPlugin(this.autoConfigs, this.autoConfigGroups);
        }
    }
}

