/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.autoconfig.web;

import io.datarouter.autoconfig.config.DatarouterAutoConfigPaths;
import io.datarouter.autoconfig.service.AutoConfigService;
import io.datarouter.storage.servertype.ServerTypeDetector;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.html.j2html.J2HtmlTable;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4PageFactory;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.ATag;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.TableTag;
import java.util.Map;
import javax.inject.Inject;

public class ViewAutoConfigsHandler
extends BaseHandler {
    private final Bootstrap4PageFactory pageFactory;
    private final ServerTypeDetector serverTypeDetector;
    private final AutoConfigService autoConfigService;
    private final DatarouterAutoConfigPaths paths;

    @Inject
    public ViewAutoConfigsHandler(Bootstrap4PageFactory pageFactory, ServerTypeDetector serverTypeDetector, AutoConfigService autoConfigService, DatarouterAutoConfigPaths paths) {
        this.pageFactory = pageFactory;
        this.serverTypeDetector = serverTypeDetector;
        this.autoConfigService = autoConfigService;
        this.paths = paths;
    }

    @BaseHandler.Handler
    public Mav viewAutoConfigs() {
        if (this.serverTypeDetector.mightBeProduction()) {
            return this.pageFactory.message(this.request, "This is not supported on production");
        }
        ATag runAllButton = (ATag)((ATag)((ATag)TagCreator.a((String)"Run All").withClass("btn btn-primary")).withType("button")).withHref(String.valueOf(this.request.getServletContext().getContextPath()) + this.paths.datarouter.autoConfig.toSlashedString());
        DivTag header = TagCreator.div((DomContent[])new DomContent[]{TagCreator.h2((String)"AutoConfigs"), runAllButton});
        DivTag content = (DivTag)TagCreator.div((DomContent[])new DomContent[]{header, this.makeContent()}).withClass("container-fluid");
        return this.pageFactory.startBuilder(this.request).withTitle("Registered AutoConfig Classes").withContent((DomContent)content).buildMav();
    }

    private DivTag makeContent() {
        TableTag table = new J2HtmlTable().withClasses(new String[]{"table table-sm table-striped my-4 border"}).withColumn("AutoConfig", Map.Entry::getKey).withHtmlColumn("Run", row -> TagCreator.td((DomContent[])new DomContent[]{((ATag)((ATag)TagCreator.a((String)"Trigger").withClass("btn btn-primary")).withType("button")).withHref(String.valueOf(this.request.getServletContext().getContextPath()) + this.paths.datarouter.autoConfigs.runForName.toSlashedString() + "?" + "name" + "=" + (String)row.getKey())})).withCaption("Total: " + this.autoConfigService.getAutoConfigByName().size()).build(this.autoConfigService.getAutoConfigByName().entrySet());
        return (DivTag)TagCreator.div((DomContent[])new DomContent[]{table}).withClass("container my-4");
    }
}

