/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.autoconfig.service;

import io.datarouter.autoconfig.config.DatarouterAutoConfigExecutors;
import io.datarouter.autoconfig.service.AutoConfig;
import io.datarouter.autoconfig.service.AutoConfigGroup;
import io.datarouter.instrumentation.changelog.ChangelogRecorder;
import io.datarouter.plugin.PluginInjector;
import io.datarouter.scanner.ParallelScannerContext;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.servertype.ServerTypeDetector;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class AutoConfigService {
    private final ServerTypeDetector serverTypeDetector;
    private final DatarouterAutoConfigExecutors.AutoConfigExecutor executor;
    private final ChangelogRecorder changelogRecorder;
    private final Map<String, Callable<String>> autoConfigByName;

    @Inject
    public AutoConfigService(PluginInjector pluginInjector, ServerTypeDetector serverTypeDetector, DatarouterAutoConfigExecutors.AutoConfigExecutor executor, ChangelogRecorder changelogRecorder) {
        this.serverTypeDetector = serverTypeDetector;
        this.executor = executor;
        this.changelogRecorder = changelogRecorder;
        this.autoConfigByName = new HashMap<String, Callable<String>>();
        pluginInjector.getInstances(AutoConfig.KEY).forEach(autoConfig -> {
            Callable<String> callable = this.autoConfigByName.put(autoConfig.getName(), (Callable<String>)autoConfig);
        });
        pluginInjector.getInstances(AutoConfigGroup.KEY).forEach(autoConfigGroup -> {
            Callable<String> callable = this.autoConfigByName.put(autoConfigGroup.getName(), (Callable<String>)autoConfigGroup);
        });
    }

    public Map<String, Callable<String>> getAutoConfigByName() {
        return this.autoConfigByName;
    }

    public String runAutoConfigAll(String triggerer) {
        this.serverTypeDetector.assertNotProductionServer();
        return (String)Scanner.of(this.getAutoConfigByName().entrySet()).parallel(new ParallelScannerContext((ExecutorService)((Object)this.executor), 8, true)).map(entry -> {
            try {
                return this.runInternal((String)entry.getKey(), (Callable)entry.getValue(), triggerer);
            }
            catch (Exception e) {
                return null;
            }
        }).collect(Collectors.joining("\n"));
    }

    public String runAutoConfigForName(String name, String triggerer) throws Exception {
        this.serverTypeDetector.assertNotProductionServer();
        Callable<String> callable = this.autoConfigByName.get(name);
        return this.runInternal(name, callable, triggerer);
    }

    private String runInternal(String name, Callable<String> callable, String triggerer) throws Exception {
        String autoConfig = callable.call();
        ChangelogRecorder.DatarouterChangelogDto changelogDto = new ChangelogRecorder.DatarouterChangelogDtoBuilder("AutoConfig", name, "triggered", triggerer).build();
        this.changelogRecorder.record(changelogDto);
        return autoConfig;
    }
}

