/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service.deprovisioning;

import io.datarouter.auth.service.deprovisioning.UserDeprovisioningListener;
import io.datarouter.auth.service.deprovisioning.UserDeprovisioningListeners;
import io.datarouter.auth.service.deprovisioning.UserDeprovisioningStrategy;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class UserDeprovisioningService {
    private static Logger logger = LoggerFactory.getLogger(UserDeprovisioningService.class);
    @Inject
    private UserDeprovisioningStrategy userDeprovisioningServiceStrategy;
    @Inject
    private UserDeprovisioningListeners listeners;

    public final List<String> flagUsers(List<String> usernames, Optional<String> editorUsername) {
        return this.executeStrategyAndNotifyListeners(this.userDeprovisioningServiceStrategy::flagUsers, usernames, editorUsername, $ -> $::onFlagUsers, $ -> $::onFlaggedUsers);
    }

    public final List<String> deprovisionUsers(List<String> usernames, Optional<String> editorUsername) {
        return this.executeStrategyAndNotifyListeners(this.userDeprovisioningServiceStrategy::deprovisionUsers, usernames, editorUsername, $ -> $::onDeprovisionUsers, $ -> $::onDeprovisionedUsers);
    }

    public final List<String> restoreUsers(List<String> usernames, Optional<String> editorUsername) {
        return this.executeStrategyAndNotifyListeners(this.userDeprovisioningServiceStrategy::restoreUsers, usernames, editorUsername, $ -> $::onRestoreUsers, $ -> $::onRestoredUsers);
    }

    private List<String> executeStrategyAndNotifyListeners(BiFunction<List<String>, Optional<String>, List<String>> strategy, List<String> usernames, Optional<String> editorUsername, Function<UserDeprovisioningListener, Consumer<List<String>>> preListenerSelector, Function<UserDeprovisioningListener, Consumer<List<String>>> postListenerSelector) {
        this.notifyListeners(preListenerSelector, usernames);
        List<String> result = strategy.apply(usernames, editorUsername);
        this.notifyListeners(postListenerSelector, usernames);
        return result;
    }

    private void notifyListeners(Function<UserDeprovisioningListener, Consumer<List<String>>> methodSelector, List<String> usernames) {
        AtomicInteger numErrors = new AtomicInteger();
        List listenerList = (List)this.listeners.get();
        listenerList.forEach(listener -> {
            try {
                ((Consumer)methodSelector.apply((UserDeprovisioningListener)listener)).accept(usernames);
            }
            catch (RuntimeException e) {
                logger.error("Failed to notify UserDeprovisioningListener", (Throwable)e);
                numErrors.incrementAndGet();
            }
        });
        logger.info("Notified size={} UserDeprovisioningListeners with numErrors={}", (Object)listenerList.size(), (Object)numErrors.get());
    }
}

