/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.client;

import io.datarouter.auth.client.BaseSimpleDatarouterClientSettings;
import io.datarouter.auth.service.DefaultDatarouterAccountKeysSupplier;
import io.datarouter.httpclient.client.DatarouterHttpClientSettings;
import io.datarouter.instrumentation.refreshable.RefreshableSupplier;
import io.datarouter.storage.setting.DefaultSettingValue;
import io.datarouter.storage.setting.SettingFinder;
import io.datarouter.storage.setting.cached.CachedSetting;
import io.datarouter.storage.setting.cached.impl.StringCachedSetting;
import java.net.URI;

public abstract class BaseDatarouterClientSettings
extends BaseSimpleDatarouterClientSettings
implements DatarouterHttpClientSettings {
    public final CachedSetting<String> endpointDomain;
    public final CachedSetting<String> endpointPath;
    public final CachedSetting<String> apiKey;
    public final CachedSetting<String> privateKey;
    public final RefreshableSupplier<String> refreshableApiKey;
    public final RefreshableSupplier<String> refreshablePrivateKey;

    public BaseDatarouterClientSettings(SettingFinder finder, DefaultDatarouterAccountKeysSupplier defaultDatarouterAccountKeys, String settingNodeName, String contextPath, DefaultSettingValue<String> endpointDomainDefaults) {
        super(finder, settingNodeName);
        this.endpointDomain = this.registerStrings("endpointDomain", endpointDomainDefaults);
        this.endpointPath = this.registerString("endpointPath", contextPath);
        this.apiKey = this.registerString("apiKey", defaultDatarouterAccountKeys.getDefaultApiKey());
        this.privateKey = this.registerString("privateKey", defaultDatarouterAccountKeys.getDefaultSecretKey());
        this.refreshableApiKey = new StringCachedSetting.RefreshableStringCachedSetting(this.apiKey);
        this.refreshablePrivateKey = new StringCachedSetting.RefreshableStringCachedSetting(this.privateKey);
    }

    public URI getEndpointUrl() {
        return URI.create("https://" + (String)this.endpointDomain.get() + (String)this.endpointPath.get());
    }

    public String getApiKey() {
        return (String)this.apiKey.get();
    }

    public RefreshableSupplier<String> getRefreshableApiKey() {
        return this.refreshableApiKey;
    }

    public String getPrivateKey() {
        return (String)this.privateKey.get();
    }

    public RefreshableSupplier<String> getRefreshablePrivateKey() {
        return this.refreshablePrivateKey;
    }
}

