/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.cache;

import io.datarouter.auth.storage.accountpermission.BaseDatarouterAccountPermissionDao;
import io.datarouter.auth.storage.accountpermission.DatarouterAccountPermissionKey;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DatarouterAccountPermissionKeysByPrefixCache {
    private final BaseDatarouterAccountPermissionDao dao;
    private final AtomicReference<Map<DatarouterAccountPermissionKey, List<DatarouterAccountPermissionKey>>> cache;

    @Inject
    public DatarouterAccountPermissionKeysByPrefixCache(BaseDatarouterAccountPermissionDao dao) {
        this.dao = dao;
        this.cache = new AtomicReference<Map<DatarouterAccountPermissionKey, List<DatarouterAccountPermissionKey>>>(this.load());
    }

    public Map<DatarouterAccountPermissionKey, List<DatarouterAccountPermissionKey>> load() {
        return this.dao.scanKeys().groupBy(DatarouterAccountPermissionKey::getAccountPrefix);
    }

    public void refresh() {
        this.cache.set(this.load());
    }

    public List<DatarouterAccountPermissionKey> get(DatarouterAccountPermissionKey prefix) {
        return this.cache.get().get((Object)prefix);
    }
}

