/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service;

import io.datarouter.auth.service.DatarouterUserEditService;
import io.datarouter.auth.service.DatarouterUserService;
import io.datarouter.auth.storage.permissionrequest.DatarouterPermissionRequest;
import io.datarouter.auth.storage.permissionrequest.DatarouterPermissionRequestDao;
import io.datarouter.auth.storage.user.DatarouterUserDao;
import io.datarouter.auth.storage.userhistory.DatarouterUserHistory;
import io.datarouter.auth.storage.userhistory.DatarouterUserHistoryDao;
import io.datarouter.auth.storage.userhistory.DatarouterUserHistoryKey;
import io.datarouter.email.html.J2HtmlDatarouterEmailBuilder;
import io.datarouter.email.type.DatarouterEmailTypes;
import io.datarouter.email.type.SimpleEmailType;
import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.servertype.ServerTypeDetector;
import io.datarouter.web.email.DatarouterHtmlEmailService;
import io.datarouter.web.user.databean.DatarouterUser;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.PTag;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DatarouterUserHistoryService {
    @Inject
    private DatarouterUserDao baseDatarouterUserDao;
    @Inject
    private DatarouterUserHistoryDao baseDatarouterUserHistoryDao;
    @Inject
    private DatarouterPermissionRequestDao permissionRequestDao;
    @Inject
    private DatarouterUserService datarouterUserService;
    @Inject
    private DatarouterHtmlEmailService htmlEmailService;
    @Inject
    private DatarouterUserEditService userEditService;
    @Inject
    private DatarouterEmailTypes.PermissionRequestEmailType permissionRequestEmailType;
    @Inject
    private ServerTypeDetector serverTypeDetector;

    public Map<DatarouterPermissionRequest, Optional<String>> getResolvedRequestToHistoryChangesMap(List<DatarouterPermissionRequest> requests) {
        Map historyMap = Scanner.of(requests).map(DatarouterPermissionRequest::toUserHistoryKey).map(key -> key.orElse(null)).include(Objects::nonNull).batch(100).map(this.baseDatarouterUserHistoryDao::getMulti).concat(Scanner::of).toMap(BaseDatabean::getKey, DatarouterUserHistory::getChanges);
        return Scanner.of(requests).deduplicateConsecutive().toMap(Function.identity(), request -> request.toUserHistoryKey().map(historyKey -> historyMap.getOrDefault(historyKey, request.getResolution().getPersistentString())));
    }

    public Optional<String> getResolutionDescription(DatarouterPermissionRequest request, Map<DatarouterUserHistoryKey, String> historyMap) {
        return request.toUserHistoryKey().map(historyKey -> historyMap.getOrDefault(historyKey, request.getResolution().getPersistentString()));
    }

    public void putAndRecordCreate(DatarouterUser user, Long editorId, String description) {
        this.baseDatarouterUserDao.put(user);
        this.baseDatarouterUserHistoryDao.put(new DatarouterUserHistory(user.getId(), user.getCreatedInstant(), editorId, DatarouterUserHistory.DatarouterUserChangeType.CREATE, description));
    }

    public void putAndRecordPasswordChange(DatarouterUser user, DatarouterUserHistory history, String signinUrl) {
        this.doPutAndRecordEdit(user, history);
        this.sendPasswordChangeEmail(user, history, signinUrl);
    }

    public void putAndRecordRoleEdit(DatarouterUser user, DatarouterUserHistory history, String signinUrl) {
        this.doPutAndRecordEdit(user, history);
        this.sendRoleEditEmail(user, history, signinUrl);
    }

    public void recordMessage(DatarouterUser user, DatarouterUser editor, String message) {
        this.baseDatarouterUserHistoryDao.put(new DatarouterUserHistory(user.getId(), Instant.now(), editor.getId(), DatarouterUserHistory.DatarouterUserChangeType.INFO, message));
    }

    public void recordDeprovisions(List<DatarouterUser> users, Optional<DatarouterUser> editor) {
        Instant time = Instant.now();
        Long editorId = editor.map(DatarouterUser::getId).orElse(1L);
        Map histories = Scanner.of(users).map(user -> new DatarouterUserHistory(user.getId(), time, editorId, DatarouterUserHistory.DatarouterUserChangeType.DEPROVISION, "deprovisioned")).flush(this.baseDatarouterUserHistoryDao::putMulti).toMap(history -> ((DatarouterUserHistoryKey)history.getKey()).getUserId());
        ((Scanner)Scanner.of(users).map(DatarouterUser::getId).listTo(this.permissionRequestDao::scanOpenPermissionRequestsForUsers)).map(request -> request.decline(time)).flush(this.permissionRequestDao::putMulti);
        editor.ifPresent(editorUser -> users.forEach(user -> this.sendDeprovisioningEmail((DatarouterUser)user, (DatarouterUserHistory)((Object)((Object)((Object)histories.get(user.getId())))), (DatarouterUser)editorUser)));
    }

    public void recordRestores(List<DatarouterUser> users, Optional<DatarouterUser> editor) {
        Instant time = Instant.now();
        Long editorId = editor.map(DatarouterUser::getId).orElse(null);
        Scanner.of(users).map(user -> new DatarouterUserHistory(user.getId(), time, editorId, DatarouterUserHistory.DatarouterUserChangeType.RESTORE, "restored")).flush(this.baseDatarouterUserHistoryDao::putMulti);
    }

    private void doPutAndRecordEdit(DatarouterUser user, DatarouterUserHistory history) {
        this.baseDatarouterUserDao.put(user);
        this.baseDatarouterUserHistoryDao.put(history);
        this.permissionRequestDao.scanOpenPermissionRequestsForUser(((DatarouterUserHistoryKey)history.getKey()).getUserId()).map(history::resolvePermissionRequest).flush(this.permissionRequestDao::putMulti);
    }

    private void sendPasswordChangeEmail(DatarouterUser user, DatarouterUserHistory history, String signInUrl) {
        DatarouterUser editor = this.datarouterUserService.getUserById(history.getEditor());
        PTag p1 = TagCreator.p((String)String.format("Your user (%s) password has been changed by user %s (%s).", user.getUsername(), editor.getId(), editor.getUsername()));
        PTag p2 = TagCreator.p((String)("Changes: " + history.getChanges()));
        DivTag content = TagCreator.div((DomContent[])new DomContent[]{p1, p2, DatarouterUserHistoryService.makeSignInParagraph(signInUrl)});
        J2HtmlDatarouterEmailBuilder emailBuilder = this.htmlEmailService.startEmailBuilder().withSubject(this.userEditService.getPermissionRequestEmailSubject(user)).withTitle("Password Changed").withTitleHref(signInUrl).withContent((ContainerTag)content).from(user.getUsername()).to(user.getUsername());
        this.htmlEmailService.trySendJ2Html(emailBuilder);
    }

    private void sendRoleEditEmail(DatarouterUser user, DatarouterUserHistory history, String signInUrl) {
        DatarouterUser editor = this.datarouterUserService.getUserById(history.getEditor());
        PTag p1 = TagCreator.p((String)String.format("%s permissions have been edited by %s", user.getUsername(), editor.getUsername()));
        PTag p2 = TagCreator.p((String)("Changes: " + history.getChanges()));
        DivTag content = TagCreator.div((DomContent[])new DomContent[]{p1, p2, DatarouterUserHistoryService.makeSignInParagraph(signInUrl)});
        J2HtmlDatarouterEmailBuilder emailBuilder = this.htmlEmailService.startEmailBuilder().withSubject(this.userEditService.getPermissionRequestEmailSubject(user)).withTitle("Permissions Changed").withTitleHref(signInUrl).withContent((ContainerTag)content).from(user.getUsername()).to(user.getUsername()).to(editor.getUsername()).to((SimpleEmailType)this.permissionRequestEmailType, this.serverTypeDetector.mightBeProduction()).toSubscribers(this.serverTypeDetector.mightBeProduction()).toAdmin(this.serverTypeDetector.mightBeDevelopment());
        this.htmlEmailService.trySendJ2Html(emailBuilder);
    }

    private void sendDeprovisioningEmail(DatarouterUser user, DatarouterUserHistory history, DatarouterUser editor) {
        DivTag content = TagCreator.div((DomContent[])new DomContent[]{TagCreator.p((String)String.format("Your user (%s) has been %s by user %s (%s).", user.getUsername(), history.getChanges(), editor.getId(), editor.getUsername()))});
        J2HtmlDatarouterEmailBuilder emailBuilder = this.htmlEmailService.startEmailBuilder().withSubject(this.userEditService.getPermissionRequestEmailSubject(user)).withTitle("Permissions Changed").withContent((ContainerTag)content).from(user.getUsername()).to(user.getUsername());
        this.htmlEmailService.trySendJ2Html(emailBuilder);
    }

    private static ContainerTag<?> makeSignInParagraph(String signInUrl) {
        return TagCreator.p((DomContent[])new DomContent[]{TagCreator.text((String)"Please sign in again to refresh your session: "), TagCreator.a((String)"sign in").withHref(signInUrl)});
    }
}

